/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec.internal.typed;

import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.IncludeFieldSpec;
import io.crnk.core.queryspec.IncludeRelationSpec;
import io.crnk.core.queryspec.PathSpec;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.SortSpec;
import io.crnk.core.queryspec.internal.typed.PathSpecBase;
import io.crnk.core.queryspec.internal.typed.ResourcePathSpec;
import java.util.ArrayList;

public class TypedQuerySpec<T, P extends ResourcePathSpec>
extends QuerySpec {
    private final P basePath;

    protected TypedQuerySpec(Class<T> resourceClass, P basePath) {
        super(resourceClass);
        this.basePath = basePath;
    }

    public P sort() {
        PathSpec pathSpec = this.createNonEmptyPathSpec();
        SortSpec sortSpec = new SortSpec(pathSpec, Direction.ASC);
        pathSpec.getElements().remove(0);
        this.addSort(sortSpec);
        return (P)((ResourcePathSpec)((PathSpecBase)this.basePath).bindSpec(sortSpec));
    }

    public P filter() {
        PathSpec pathSpec = this.createNonEmptyPathSpec();
        FilterSpec filterSpec = new FilterSpec(pathSpec, FilterOperator.EQ, null);
        pathSpec.getElements().remove(0);
        this.addFilter(filterSpec);
        return (P)((ResourcePathSpec)((PathSpecBase)this.basePath).bindSpec(filterSpec));
    }

    public P include() {
        PathSpec pathSpec = this.createNonEmptyPathSpec();
        IncludeRelationSpec includeSpec = new IncludeRelationSpec(pathSpec);
        pathSpec.getElements().remove(0);
        this.getIncludedRelations().add(includeSpec);
        return (P)((ResourcePathSpec)((PathSpecBase)this.basePath).bindSpec(includeSpec));
    }

    public P field() {
        PathSpec pathSpec = this.createNonEmptyPathSpec();
        IncludeFieldSpec fieldSpec = new IncludeFieldSpec(pathSpec);
        pathSpec.getElements().remove(0);
        this.getIncludedFields().add(fieldSpec);
        return (P)((ResourcePathSpec)((PathSpecBase)this.basePath).bindSpec(fieldSpec));
    }

    private PathSpec createNonEmptyPathSpec() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("dummy");
        return PathSpec.of(list);
    }
}

