/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.queryspec.Direction;
import io.crnk.core.queryspec.FilterOperator;
import io.crnk.core.queryspec.FilterSpec;
import io.crnk.core.queryspec.SortSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonSerialize(using=ToStringSerializer.class)
public class PathSpec {
    protected List<String> elements;

    protected PathSpec() {
    }

    protected PathSpec(String path) {
        this.elements = PathSpec.of((String)path).elements;
    }

    public static PathSpec of(String ... elements) {
        return elements != null ? PathSpec.of(Arrays.asList(elements)) : null;
    }

    public static PathSpec of(List<String> elements) {
        if (elements == null) {
            return null;
        }
        PathSpec pathSpec = new PathSpec();
        pathSpec.elements = elements;
        return pathSpec;
    }

    public static PathSpec empty() {
        PathSpec pathSpec = new PathSpec();
        pathSpec.elements = Collections.emptyList();
        return pathSpec;
    }

    public PathSpec clone() {
        return PathSpec.of(new ArrayList<String>(this.elements));
    }

    public static PathSpec of(String path) {
        return PathSpec.of(Arrays.asList(path.split("\\.")));
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setElements(List<String> elements) {
        this.elements = elements;
    }

    public String toString() {
        return StringUtils.join(".", this.elements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSpec pathSpec = (PathSpec)o;
        return Objects.equals(this.elements, pathSpec.elements);
    }

    public int hashCode() {
        return Objects.hash(this.elements);
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public SortSpec sort(Direction dir) {
        return new SortSpec(this, dir);
    }

    public FilterSpec filter(FilterOperator operator, Object value) {
        return new FilterSpec(this, operator, value);
    }

    public PathSpec append(String fieldName) {
        ArrayList<String> copy = new ArrayList<String>(this.elements);
        copy.add(fieldName);
        return PathSpec.of(copy);
    }
}

