/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.queryspec;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.crnk.core.engine.internal.utils.CompareUtils;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.queryspec.mapper.QueryParameter;
import java.lang.reflect.Type;
import java.util.Collection;

@JsonSerialize(using=ToStringSerializer.class)
public class FilterOperator {
    public static final FilterOperator AND = new FilterOperator("AND"){

        @Override
        public boolean matches(Object value1, Object value2) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FilterOperator SELECT = new FilterOperator("SELECT"){

        @Override
        public boolean matches(Object value1, Object value2) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FilterOperator GROUP = new FilterOperator("GROUP"){

        @Override
        public boolean matches(Object value1, Object value2) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FilterOperator LIKE = new FilterOperator("LIKE"){

        @Override
        public Type getFilterType(QueryParameter queryParameter, Type attributeType) {
            return String.class;
        }

        @Override
        public boolean matches(Object value, Object likePattern) {
            if (likePattern == null) {
                throw new BadRequestException("LIKE pattern cannot be null");
            }
            if (value == null) {
                return false;
            }
            String text = value.toString();
            char[] queryTerm = likePattern.toString().toCharArray();
            StringBuilder regex = new StringBuilder();
            regex.append(".*");
            String escapedCharacters = "[\\^$.|?*+()";
            for (char c : queryTerm) {
                if (escapedCharacters.contains(Character.toString(c))) {
                    regex.append('\\');
                    regex.append(c);
                    continue;
                }
                if (c == '%') {
                    regex.append(".*");
                    continue;
                }
                regex.append(Character.toLowerCase(c));
            }
            regex.append(".*");
            return text.toLowerCase().matches(regex.toString());
        }
    };
    public static final FilterOperator OR = new FilterOperator("OR"){

        @Override
        public boolean matches(Object value1, Object value2) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FilterOperator NOT = new FilterOperator("NOT"){

        @Override
        public boolean matches(Object value1, Object value2) {
            throw new UnsupportedOperationException();
        }
    };
    public static final FilterOperator EQ = new FilterOperator("EQ"){

        @Override
        public boolean matches(Object value1, Object value2) {
            if (value2 instanceof Collection) {
                return ((Collection)value2).contains(value1);
            }
            return CompareUtils.isEquals(value1, value2);
        }
    };
    public static final FilterOperator LT = new FilterOperator("LT"){

        @Override
        public boolean matches(Object value1, Object value2) {
            Comparable c1 = (Comparable)value1;
            Comparable c2 = (Comparable)value2;
            return c1.compareTo(c2) < 0;
        }
    };
    public static final FilterOperator LE = new FilterOperator("LE"){

        @Override
        public boolean matches(Object value1, Object value2) {
            Comparable c1 = (Comparable)value1;
            Comparable c2 = (Comparable)value2;
            return c1 != null && c1 != null && c1.compareTo(c2) <= 0;
        }
    };
    public static final FilterOperator GT = new FilterOperator("GT"){

        @Override
        public boolean matches(Object value1, Object value2) {
            Comparable c1 = (Comparable)value1;
            Comparable c2 = (Comparable)value2;
            return c1 != null && c1 != null && c1.compareTo(c2) > 0;
        }
    };
    public static final FilterOperator GE = new FilterOperator("GE"){

        @Override
        public boolean matches(Object value1, Object value2) {
            Comparable c1 = (Comparable)value1;
            Comparable c2 = (Comparable)value2;
            return c1 != null && c1 != null && c1.compareTo(c2) >= 0;
        }
    };
    public static final FilterOperator NEQ = new FilterOperator("NEQ"){

        @Override
        public boolean matches(Object value1, Object value2) {
            return !CompareUtils.isEquals(value1, value2);
        }
    };
    private final String id;

    protected FilterOperator(String id) {
        this.id = id;
    }

    public String name() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FilterOperator) {
            FilterOperator other = (FilterOperator)obj;
            return CompareUtils.isEquals(this.id, other.id);
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public String getName() {
        return this.id;
    }

    public boolean matches(Object value1, Object value2) {
        throw new UnsupportedOperationException("not implemented");
    }

    public Type getFilterType(QueryParameter queryParameter, Type attributeType) {
        return attributeType;
    }
}

