/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.query;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.registry.ResourceRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class QueryContext {
    private String baseUrl;
    private Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private String requestPath;
    private int requestVersion = -1;
    private HttpRequestContext requestContext;

    public HttpRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(HttpRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public int getRequestVersion() {
        return this.requestVersion;
    }

    public QueryContext setRequestVersion(int requestVersion) {
        this.requestVersion = requestVersion;
        return this;
    }

    public String getBaseUrl() {
        return Objects.requireNonNull(this.baseUrl);
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public void initializeDefaults(ResourceRegistry resourceRegistry) {
        if (this.getRequestVersion() == -1) {
            this.setRequestVersion(resourceRegistry.getLatestVersion());
        }
    }
}

