/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.crnk.core.engine.parser.ParserException;
import io.crnk.core.engine.parser.StringMapper;
import java.io.IOException;

public class JacksonStringMapper<T>
implements StringMapper<T> {
    private final ObjectReader reader;
    private final ObjectMapper mapper;

    public JacksonStringMapper(ObjectMapper mapper, Class clazz) {
        this.reader = mapper.readerFor(clazz);
        this.mapper = mapper;
    }

    @Override
    public T parse(String input) {
        TextNode node = new TextNode(input);
        try {
            return (T)this.reader.readValue((JsonNode)node);
        }
        catch (IOException e) {
            throw new ParserException("Cannot parse " + input, e);
        }
    }

    @Override
    public String toString(T input) {
        JsonNode jsonNode = this.mapper.valueToTree(input);
        if (jsonNode instanceof TextNode) {
            return jsonNode.textValue();
        }
        if (jsonNode instanceof NumericNode) {
            return jsonNode.asText();
        }
        return input.toString();
    }
}

