/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.engine.internal.utils.CompareUtils;

public class PreconditionUtil {
    private PreconditionUtil() {
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        PreconditionUtil.verifyEquals(expected, actual, message, new Object[0]);
    }

    public static void verifyEquals(Object expected, Object actual, String message, Object ... args) {
        if (!CompareUtils.isEquals(expected, actual)) {
            PreconditionUtil.fail(PreconditionUtil.format(message, args, expected, actual), new Object[0]);
        }
    }

    static String format(String message, Object[] args, Object expected, Object actual) {
        String formatted = "";
        if (message != null && !message.equals("")) {
            formatted = String.format(message, args) + " ";
        }
        String expectedString = String.valueOf(expected);
        String actualString = String.valueOf(actual);
        return formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    public static void fail(String message, Object ... args) {
        throw new IllegalStateException(message == null ? "" : String.format(message, args));
    }

    public static void assertNotNull(String message, Object object) {
        PreconditionUtil.assertTrue(message, object != null);
    }

    public static void assertTrue(String message, boolean condition) {
        PreconditionUtil.verify(condition, message, new Object[0]);
    }

    public static void assertTrue(boolean condition, String message, Object ... args) {
        PreconditionUtil.verify(condition, message, args);
    }

    public static void assertFalse(boolean condition, String message, Object ... args) {
        PreconditionUtil.verify(!condition, message, args);
    }

    public static void assertFalse(String message, boolean condition) {
        PreconditionUtil.assertTrue(message, !condition);
    }

    public static void assertNull(String message, Object object) {
        PreconditionUtil.assertTrue(message, object == null);
    }

    public static void verify(boolean condition, String messageFormat, Object ... args) {
        if (!condition) {
            String message = messageFormat != null ? String.format(messageFormat, args) : null;
            PreconditionUtil.fail(message, new Object[0]);
        }
    }
}

