/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.utils;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.utils.ExceptionUtil;
import io.crnk.core.engine.internal.utils.StringUtils;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UrlBuilder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class JsonApiUrlBuilder
implements UrlBuilder {
    private final ModuleRegistry moduleRegistry;
    private Set<String> propagatedParameters = new HashSet<String>();

    public JsonApiUrlBuilder(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
    }

    @Override
    public void addPropagatedParameter(String name) {
        this.propagatedParameters.add(name);
    }

    @Override
    public Set<String> getPropagatedParameters() {
        return this.propagatedParameters;
    }

    @Override
    public String buildUrl(QueryContext queryContext, ResourceInformation resourceInformation) {
        return this.buildUrl(queryContext, resourceInformation, null, null, null);
    }

    @Override
    public String buildUrl(QueryContext queryContext, ResourceInformation resourceInformation, Object id, QuerySpec querySpec) {
        return this.buildUrl(queryContext, resourceInformation, id, querySpec, null);
    }

    @Override
    public String buildUrl(QueryContext queryContext, ResourceInformation resourceInformation, Object id, QuerySpec querySpec, String relationshipName) {
        return this.buildUrlInternal(queryContext, resourceInformation, id, querySpec, relationshipName, true);
    }

    @Override
    public String buildUrl(QueryContext queryContext, ResourceInformation resourceInformation, Object id, QuerySpec querySpec, String relationshipName, boolean selfLink) {
        return this.buildUrlInternal(queryContext, resourceInformation, id, querySpec, relationshipName, selfLink);
    }

    private String buildUrlInternal(QueryContext queryContext, ResourceInformation resourceInformation, Object id, Object query, String relationshipName, boolean selfLink) {
        String url;
        ResourceRegistry resourceRegistry = this.moduleRegistry.getResourceRegistry();
        if (id instanceof Collection) {
            if (resourceInformation.isNested()) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            url = resourceRegistry.getResourceUrl(queryContext, resourceInformation);
            Collection ids = (Collection)id;
            ArrayList<String> strIds = new ArrayList<String>();
            for (Object idElem : ids) {
                String strIdElem = resourceInformation.toIdString(idElem);
                strIds.add(strIdElem);
            }
            url = url + "/";
            url = url + StringUtils.join(",", strIds);
        } else {
            url = id != null ? resourceRegistry.getResourceUrl(queryContext, resourceInformation, id) : resourceRegistry.getResourceUrl(queryContext, resourceInformation);
        }
        if (relationshipName != null && selfLink) {
            url = url + "/relationships/" + relationshipName;
        } else if (relationshipName != null) {
            url = url + "/" + relationshipName;
        }
        UrlParameterBuilder urlBuilder = new UrlParameterBuilder(url);
        QuerySpec querySpec = (QuerySpec)query;
        QuerySpecUrlMapper urlMapper = this.moduleRegistry.getUrlMapper();
        urlBuilder.addQueryParameters(urlMapper.serialize(querySpec, queryContext));
        if (queryContext != null) {
            this.addPropagatedParameters(urlBuilder, queryContext.getRequestContext());
        }
        return urlBuilder.toString();
    }

    private void addPropagatedParameters(UrlParameterBuilder urlBuilder, HttpRequestContext requestContext) {
        if (requestContext != null) {
            for (String propagedParameter : this.propagatedParameters) {
                Set<String> propagatedValues = requestContext.getRequestParameters().get(propagedParameter);
                if (propagatedValues == null) continue;
                urlBuilder.addQueryParameter(propagedParameter, propagatedValues);
            }
        }
    }

    class UrlParameterBuilder {
        private StringBuilder builder = new StringBuilder();
        private boolean firstParam;
        private String encoding = "UTF-8";

        public UrlParameterBuilder(String baseUrl) {
            this.builder.append(baseUrl);
            this.firstParam = !baseUrl.contains("?");
        }

        public String toString() {
            return this.builder.toString();
        }

        private void addQueryParameters(Map<String, ?> params) {
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, ?> entry : params.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    this.addQueryParameter(key, value);
                }
            }
        }

        public void addQueryParameter(String key, final String value) {
            if (this.firstParam) {
                this.builder.append("?");
                this.firstParam = false;
            } else {
                this.builder.append("&");
            }
            this.builder.append(key);
            this.builder.append("=");
            ExceptionUtil.wrapCatchedExceptions(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    UrlParameterBuilder.this.builder.append(URLEncoder.encode(value, UrlParameterBuilder.this.encoding));
                    return null;
                }
            });
        }

        private void addQueryParameter(String key, Object value) {
            if (value instanceof Collection) {
                for (Object element : (Collection)value) {
                    this.addQueryParameter(key, (String)element);
                }
            } else {
                this.addQueryParameter(key, (String)value);
            }
        }
    }
}

