/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.FilterBehavior;
import io.crnk.core.engine.filter.RepositoryBulkRequestFilterChain;
import io.crnk.core.engine.filter.RepositoryFilter;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.filter.RepositoryLinksFilterChain;
import io.crnk.core.engine.filter.RepositoryMetaFilterChain;
import io.crnk.core.engine.filter.RepositoryRequestFilterChain;
import io.crnk.core.engine.filter.RepositoryResultFilterChain;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RepositoryAdapterUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.exception.ForbiddenException;
import io.crnk.core.exception.UnauthorizedException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.repository.LinksRepository;
import io.crnk.core.repository.MetaRepository;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.links.LinksInformation;
import io.crnk.core.resource.list.DefaultResourceList;
import io.crnk.core.resource.list.ResourceList;
import io.crnk.core.resource.meta.MetaInformation;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ResponseRepositoryAdapter {
    protected ModuleRegistry moduleRegistry;

    public ResponseRepositoryAdapter(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        PreconditionUtil.verify(moduleRegistry != null, "moduleRegistry cannot be null", new Object[0]);
    }

    protected <T> Collection<T> filterResult(Collection<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryResultFilterChainImpl chain = new RepositoryResultFilterChainImpl(resources);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec));
    }

    protected JsonApiResponse getResponse(Object repository, Object result, RepositoryRequestSpec requestSpec) {
        Collection resultEntity;
        if (result instanceof JsonApiResponse) {
            return (JsonApiResponse)result;
        }
        boolean isCollection = result instanceof Collection;
        List<Object> resources = isCollection ? (List<Object>)result : Collections.singletonList(result);
        Collection filteredResult = this.filterResult(resources, requestSpec);
        MetaInformation metaInformation = this.getMetaInformation(repository, resources, requestSpec);
        LinksInformation linksInformation = this.getLinksInformation(repository, resources, requestSpec);
        if (isCollection) {
            resultEntity = filteredResult;
        } else {
            Iterator iterator = filteredResult.iterator();
            if (iterator.hasNext()) {
                resultEntity = iterator.next();
                PreconditionUtil.verify(!iterator.hasNext(), "expected unique result, got results=%s for request=%s by repository=%s", filteredResult, requestSpec, repository);
            } else {
                resultEntity = null;
            }
        }
        return new JsonApiResponse().setEntity(resultEntity).setLinksInformation(linksInformation).setMetaInformation(metaInformation);
    }

    private MetaInformation getMetaInformation(Object repository, Collection<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryMetaFilterChainImpl chain = new RepositoryMetaFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    private MetaInformation doGetMetaInformation(Object repository, Collection<?> resources, RepositoryRequestSpec requestSpec) {
        MetaInformation metaInformation = null;
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            metaInformation = resourceList.getMeta();
        }
        QueryAdapter queryAdapter = requestSpec.getQueryAdapter();
        if (repository instanceof MetaRepository) {
            metaInformation = ((MetaRepository)repository).getMetaInformation(resources, requestSpec.getResponseQuerySpec(), metaInformation);
        }
        return metaInformation;
    }

    private LinksInformation getLinksInformation(Object repository, Collection<?> resources, RepositoryRequestSpec requestSpec) {
        RepositoryLinksFilterChainImpl chain = new RepositoryLinksFilterChainImpl(repository);
        return chain.doFilter(this.newRepositoryFilterContext(requestSpec), resources);
    }

    protected RepositoryFilterContext newRepositoryFilterContext(final RepositoryRequestSpec requestSpec) {
        return new RepositoryFilterContext(){

            @Override
            public RepositoryRequestSpec getRequest() {
                return requestSpec;
            }
        };
    }

    private LinksInformation doGetLinksInformation(Object repository, Collection<?> resources, RepositoryRequestSpec requestSpec) {
        LinksInformation linksInformation = null;
        if (resources instanceof ResourceList) {
            ResourceList resourceList = (ResourceList)resources;
            boolean createLinksInformation = resourceList instanceof DefaultResourceList;
            LinksInformation newLinksInfo = RepositoryAdapterUtils.enrichLinksInformation(this.moduleRegistry, resourceList.getLinks(), resources, requestSpec);
            if (createLinksInformation) {
                ((DefaultResourceList)resources).setLinks(newLinksInfo);
            }
            linksInformation = resourceList.getLinks();
        }
        if (repository instanceof LinksRepository) {
            linksInformation = ((LinksRepository)repository).getLinksInformation(resources, requestSpec.getResponseQuerySpec(), linksInformation);
        }
        return RepositoryAdapterUtils.enrichLinksInformation(this.moduleRegistry, linksInformation, resources, requestSpec);
    }

    protected abstract class RepositoryBulkRequestFilterChainImpl<K>
    implements RepositoryBulkRequestFilterChain<K> {
        protected int filterIndex = 0;

        protected RepositoryBulkRequestFilterChainImpl() {
        }

        @Override
        public Map<K, JsonApiResponse> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterBulkRequest(context, this);
        }

        protected abstract Map<K, JsonApiResponse> invoke(RepositoryFilterContext var1);
    }

    protected abstract class RepositoryRequestFilterChainImpl
    implements RepositoryRequestFilterChain {
        protected int filterIndex = 0;

        protected RepositoryRequestFilterChainImpl() {
        }

        @Override
        public JsonApiResponse doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters;
            if (this.filterIndex == 0) {
                this.checkResourceAccess(context);
            }
            if (this.filterIndex == (filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters()).size()) {
                return this.invoke(context);
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterRequest(context, this);
        }

        private void checkResourceAccess(RepositoryFilterContext context) {
            ResourceFilterDirectory resourceFilterDirectory = ResponseRepositoryAdapter.this.moduleRegistry.getContext().getResourceFilterDirectory();
            RepositoryRequestSpec request = context.getRequest();
            ResourceInformation resourceInformation = request.getQueryAdapter().getResourceInformation();
            QueryAdapter queryAdapter = context.getRequest().getQueryAdapter();
            QueryContext queryContext = queryAdapter.getQueryContext();
            FilterBehavior filterBehavior = resourceFilterDirectory.get(resourceInformation, request.getMethod(), queryContext);
            if (filterBehavior != FilterBehavior.NONE) {
                if (filterBehavior == FilterBehavior.UNAUTHORIZED) {
                    throw new UnauthorizedException(resourceInformation, request.getMethod());
                }
                throw new ForbiddenException(resourceInformation, request.getMethod());
            }
            ResourceField relationshipField = request.getRelationshipField();
            if (relationshipField != null) {
                boolean canAccess = resourceFilterDirectory.canAccess(relationshipField, request.getMethod(), queryContext, false);
                PreconditionUtil.verify(canAccess, "ignoring not allowed, should not get here", new Object[0]);
            }
        }

        protected abstract JsonApiResponse invoke(RepositoryFilterContext var1);
    }

    class RepositoryResultFilterChainImpl<T>
    implements RepositoryResultFilterChain<T> {
        protected int filterIndex = 0;
        private Collection<T> result;

        public RepositoryResultFilterChainImpl(Collection<T> result) {
            this.result = result;
        }

        @Override
        public Collection<T> doFilter(RepositoryFilterContext context) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return this.result;
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterResult(context, this);
        }
    }

    class RepositoryLinksFilterChainImpl
    implements RepositoryLinksFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryLinksFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> LinksInformation doFilter(RepositoryFilterContext context, Collection<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetLinksInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterLinks(context, resources, this);
        }
    }

    class RepositoryMetaFilterChainImpl
    implements RepositoryMetaFilterChain {
        protected int filterIndex = 0;
        private Object repository;

        public RepositoryMetaFilterChainImpl(Object repository) {
            this.repository = repository;
        }

        @Override
        public <T> MetaInformation doFilter(RepositoryFilterContext context, Collection<T> resources) {
            List<RepositoryFilter> filters = ResponseRepositoryAdapter.this.moduleRegistry.getRepositoryFilters();
            if (this.filterIndex == filters.size()) {
                return ResponseRepositoryAdapter.this.doGetMetaInformation(this.repository, resources, context.getRequest());
            }
            RepositoryFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filterMeta(context, resources, this);
        }
    }
}

