/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.repository;

import io.crnk.core.engine.dispatcher.RepositoryRequestSpec;
import io.crnk.core.engine.filter.RepositoryFilterContext;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.repository.RepositoryRequestSpecImpl;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResponseRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.internal.utils.ResourceUtils;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.BadRequestException;
import io.crnk.core.exception.MethodNotAllowedException;
import io.crnk.core.exception.ResourceNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.queryspec.QuerySpec;
import io.crnk.core.repository.BulkResourceRepository;
import io.crnk.core.repository.ResourceRepository;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.resource.list.ResourceList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRepositoryAdapterImpl
extends ResponseRepositoryAdapter
implements ResourceRepositoryAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRepositoryAdapterImpl.class);
    private final ResourceRepository resourceRepository;
    private final ResourceRepositoryInformation repositoryInformation;
    private final ResourceInformation resourceInformation;
    private boolean return404OnNull;

    public ResourceRepositoryAdapterImpl(ResourceRepositoryInformation repositoryInformation, ModuleRegistry moduleRegistry, ResourceRepository resourceRepository) {
        super(moduleRegistry);
        this.resourceInformation = repositoryInformation.getResource();
        this.repositoryInformation = repositoryInformation;
        this.resourceRepository = resourceRepository;
        this.return404OnNull = Boolean.parseBoolean(moduleRegistry.getPropertiesProvider().getProperty("crnk.config.resource.response.return_404"));
    }

    @Override
    public ResourceRepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    @Override
    public Result<JsonApiResponse> findOne(Object id, QueryAdapter queryAdapter) {
        if (!this.resourceInformation.getAccess().isReadable()) {
            throw new MethodNotAllowedException(HttpMethod.GET.toString());
        }
        id = ResourceUtils.toTypedId(this.resourceInformation, id);
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Serializable id = request.getId();
                Object resource = ResourceRepositoryAdapterImpl.this.resourceRepository.findOne(id, request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation));
                if (resource == null && ResourceRepositoryAdapterImpl.this.return404OnNull) {
                    throw new ResourceNotFoundException(ResourceRepositoryAdapterImpl.this.resourceInformation.getResourceType());
                }
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindId(this.moduleRegistry, this.resourceInformation, queryAdapter, (Serializable)id);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findAll(QueryAdapter queryAdapter) {
        if (!this.resourceInformation.getAccess().isReadable()) {
            throw new MethodNotAllowedException(HttpMethod.GET.toString());
        }
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                QuerySpec querySpec = request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation);
                ResourceList resources = ResourceRepositoryAdapterImpl.this.resourceRepository.findAll(querySpec);
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindAll(this.moduleRegistry, this.resourceInformation, queryAdapter);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> findAll(Collection ids, QueryAdapter queryAdapter) {
        PreconditionUtil.verify(!ids.isEmpty(), "empty set of IDs passed as argument", new Object[0]);
        ids = ResourceUtils.toTypedIds(this.resourceInformation, ids);
        if (!this.resourceInformation.getAccess().isReadable()) {
            throw new MethodNotAllowedException(HttpMethod.GET.toString());
        }
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Collection ids = request.getIds();
                ResourceList resources = ResourceRepositoryAdapterImpl.this.resourceRepository.findAll(ids, request.getQuerySpec(ResourceRepositoryAdapterImpl.this.resourceInformation));
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resources, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forFindIds(this.moduleRegistry, this.resourceInformation, queryAdapter, ids);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> update(Object entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.PATCH);
    }

    @Override
    public Result<JsonApiResponse> create(Object entity, QueryAdapter queryAdapter) {
        return this.save(entity, queryAdapter, HttpMethod.POST);
    }

    private Result<JsonApiResponse> save(Object entity, QueryAdapter queryAdapter, final HttpMethod method) {
        if (method == HttpMethod.POST && !this.resourceInformation.getAccess().isPostable()) {
            throw new MethodNotAllowedException(method.toString());
        }
        if (method == HttpMethod.PATCH && !this.resourceInformation.getAccess().isPatchable()) {
            throw new MethodNotAllowedException(method.toString());
        }
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                List resource;
                RepositoryRequestSpec request = context.getRequest();
                Object entity = request.getEntity();
                if (method == HttpMethod.POST) {
                    if (entity instanceof Collection) {
                        if (!(ResourceRepositoryAdapterImpl.this.resourceRepository instanceof BulkResourceRepository)) {
                            throw new BadRequestException("no bulk operations implemented");
                        }
                        resource = ((BulkResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).create((List)entity);
                    } else {
                        resource = ResourceRepositoryAdapterImpl.this.resourceRepository.create(entity);
                    }
                } else if (entity instanceof Collection) {
                    if (!(ResourceRepositoryAdapterImpl.this.resourceRepository instanceof BulkResourceRepository)) {
                        throw new BadRequestException("no bulk operations implemented");
                    }
                    resource = ((BulkResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).save((List)entity);
                } else {
                    resource = ResourceRepositoryAdapterImpl.this.resourceRepository.save(entity);
                }
                return ResourceRepositoryAdapterImpl.this.getResponse(ResourceRepositoryAdapterImpl.this.resourceRepository, resource, request);
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forSave(this.moduleRegistry, method, this.resourceInformation, queryAdapter, entity);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Result<JsonApiResponse> delete(Object id, QueryAdapter queryAdapter) {
        id = ResourceUtils.toTypedId(this.resourceInformation, id);
        if (!this.resourceInformation.getAccess().isDeletable()) {
            throw new MethodNotAllowedException(HttpMethod.DELETE.toString());
        }
        ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl chain = new ResponseRepositoryAdapter.RepositoryRequestFilterChainImpl(){

            @Override
            protected JsonApiResponse invoke(RepositoryFilterContext context) {
                RepositoryRequestSpec request = context.getRequest();
                Serializable id = request.getId();
                if (id instanceof Collection) {
                    if (!(ResourceRepositoryAdapterImpl.this.resourceRepository instanceof BulkResourceRepository)) {
                        throw new BadRequestException("no bulk operations implemented");
                    }
                    ((BulkResourceRepository)ResourceRepositoryAdapterImpl.this.resourceRepository).delete((List)((Object)id));
                } else {
                    ResourceRepositoryAdapterImpl.this.resourceRepository.delete(id);
                }
                return new JsonApiResponse();
            }
        };
        RepositoryRequestSpec requestSpec = RepositoryRequestSpecImpl.forDelete(this.moduleRegistry, this.resourceInformation, queryAdapter, (Serializable)id);
        return new ImmediateResult<JsonApiResponse>(chain.doFilter(this.newRepositoryFilterContext(requestSpec)));
    }

    @Override
    public Object getImplementation() {
        return this.resourceRepository;
    }

    public Class<?> getResourceClass() {
        return this.resourceInformation.getResourceClass();
    }
}

