/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.registry;

import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.contributor.ResourceFieldContributor;
import io.crnk.core.engine.information.contributor.ResourceFieldContributorContext;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryInformationProvider;
import io.crnk.core.engine.information.repository.RepositoryInformationProviderContext;
import io.crnk.core.engine.information.repository.RepositoryMethodAccess;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.information.DefaultInformationBuilder;
import io.crnk.core.engine.internal.information.repository.RelationshipRepositoryInformationImpl;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.registry.RegistryEntryImpl;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.RepositoryAdapterFactory;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.RegistryEntryBuilder;
import io.crnk.core.engine.registry.ResourceRegistryAware;
import io.crnk.core.exception.ResourceFieldNotFoundException;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.internal.DefaultRepositoryInformationProviderContext;
import io.crnk.core.repository.MatchedRelationshipRepository;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import io.crnk.core.repository.foward.ForwardingDirection;
import io.crnk.core.repository.foward.ForwardingRelationshipRepository;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegistryEntryBuilder
implements RegistryEntryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRegistryEntryBuilder.class);
    public static boolean FAIL_ON_MISSING_REPOSITORY = true;
    @Deprecated
    public static boolean WARN_MISSING_RELATIONSHIP_REPOSITORIES = true;
    private final DefaultInformationBuilder informationBuilder;
    private ModuleRegistry moduleRegistry;
    private DefaultResourceRepository resourceRepository;
    private Map<String, DefaultRelationshipRepository> relationshipRepositoryMap = new HashMap<String, DefaultRelationshipRepository>();
    private InformationBuilder.ResourceInformationBuilder resource;

    public DefaultRegistryEntryBuilder(ModuleRegistry moduleRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.informationBuilder = moduleRegistry.getInformationBuilder();
    }

    @Override
    public void fromImplementation(Object repository) {
        DefaultRepositoryInformationProviderContext builderContext;
        RepositoryInformationProvider repositoryInformationBuilder = this.moduleRegistry.getRepositoryInformationBuilder();
        RepositoryInformation repositoryInformation = repositoryInformationBuilder.build(repository, (RepositoryInformationProviderContext)(builderContext = new DefaultRepositoryInformationProviderContext(this.moduleRegistry)));
        if (repositoryInformation instanceof ResourceRepositoryInformation) {
            ResourceRepositoryInformation resourceRepositoryInformation = (ResourceRepositoryInformation)repositoryInformation;
            ResourceInformation resourceInformation = resourceRepositoryInformation.getResourceInformation().get();
            this.resource().from(resourceInformation);
            this.resourceRepository().information().from(resourceRepositoryInformation);
            this.resourceRepository().instance(repository);
        }
    }

    @Override
    public RegistryEntryBuilder.ResourceRepositoryEntryBuilder resourceRepository() {
        if (this.resourceRepository == null) {
            this.resourceRepository = new DefaultResourceRepository();
        }
        return this.resourceRepository;
    }

    @Override
    public InformationBuilder.ResourceInformationBuilder resource() {
        if (this.resource == null) {
            this.resource = this.informationBuilder.createResource(null, null, null);
        }
        return this.resource;
    }

    @Override
    public RegistryEntryBuilder.RelationshipRepositoryEntryBuilder relationshipRepositoryForField(String fieldName) {
        DefaultRelationshipRepository repository = this.relationshipRepositoryMap.get(fieldName);
        if (repository == null) {
            repository = new DefaultRelationshipRepository(null);
            this.relationshipRepositoryMap.put(fieldName, repository);
        }
        return repository;
    }

    @Override
    public RegistryEntry build() {
        if (this.resource == null) {
            return null;
        }
        ResourceInformation resourceInformation = this.buildResource();
        ResourceRepositoryAdapter resourceRepositoryAdapter = this.buildResourceRepositoryAdapter(resourceInformation);
        Map<ResourceField, RelationshipRepositoryAdapter> relationshipEntries = this.buildRelationshipAdapters(resourceInformation);
        return new RegistryEntryImpl(resourceInformation, resourceRepositoryAdapter, relationshipEntries, this.moduleRegistry);
    }

    private void checkRelationshipNaming(ResourceInformation resourceInformation) {
        for (String relationshipName : this.relationshipRepositoryMap.keySet()) {
            if (resourceInformation.findFieldByUnderlyingName(relationshipName) != null) continue;
            throw new ResourceFieldNotFoundException("failed to find relationship field '" + relationshipName + "' to setup registered relationship repository");
        }
    }

    private Map<ResourceField, RelationshipRepositoryAdapter> buildRelationshipAdapters(ResourceInformation resourceInformation) {
        this.checkRelationshipNaming(resourceInformation);
        HashMap<ResourceField, RelationshipRepositoryAdapter> map = new HashMap<ResourceField, RelationshipRepositoryAdapter>();
        for (ResourceField relationshipField : resourceInformation.getRelationshipFields()) {
            MatchedRelationship relationshipEntry = this.findMatchedRelationship(relationshipField);
            if (relationshipEntry != null) {
                map.put(relationshipField, relationshipEntry.getAdapter());
                continue;
            }
            LOGGER.warn("{}.{}: no relationship repository found", this.toShortName(resourceInformation), (Object)relationshipField.getUnderlyingName());
        }
        return map;
    }

    private MatchedRelationship findMatchedRelationship(ResourceField relationshipField) {
        LookupIncludeBehavior lookupIncludeBehavior;
        MatchedRelationship match = null;
        DefaultRelationshipRepository repository = this.relationshipRepositoryMap.get(relationshipField.getUnderlyingName());
        if (repository != null) {
            RelationshipRepositoryInformation relationshipInformation = repository.information.build();
            match = new MatchedRelationship(relationshipField, relationshipInformation, repository.instance);
            ResourceInformation sourceInformation = relationshipField.getResourceInformation();
            LOGGER.debug("{}.{}: using configured relationship repository: {}", new Object[]{this.toShortName(sourceInformation), relationshipField.getUnderlyingName(), match});
            ((ResourceFieldImpl)relationshipField).setRelationshipRepositoryBehavior(RelationshipRepositoryBehavior.CUSTOM);
        }
        if (match == null && (match = this.findRelationshipMatch(relationshipField)) != null) {
            ResourceInformation sourceInformation = relationshipField.getResourceInformation();
            ((ResourceFieldImpl)relationshipField).setRelationshipRepositoryBehavior(RelationshipRepositoryBehavior.CUSTOM);
            LOGGER.debug("{}.{}: found matching relationship repository: {}", new Object[]{this.toShortName(sourceInformation), relationshipField.getUnderlyingName(), match});
        }
        if (match == null) {
            match = this.setupForwardingRepository(relationshipField);
        }
        if ((lookupIncludeBehavior = relationshipField.getLookupIncludeBehavior()) == LookupIncludeBehavior.DEFAULT) {
            if (relationshipField.hasIdField()) {
                LOGGER.debug("{}.{}: relationId field enforces LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL to resolve resource from id", this.toShortName(relationshipField.getResourceInformation()), (Object)relationshipField.getUnderlyingName());
                ((ResourceFieldImpl)relationshipField).setLookupIncludeBehavior(LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL);
            } else if (relationshipField.getRelationshipRepositoryBehavior() == RelationshipRepositoryBehavior.FORWARD_OPPOSITE) {
                LOGGER.debug("{}.{}: RelationshipRepositoryBehavior.FORWARD_OPPOSITE enforces LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL to resolve relationship from opposite side", this.toShortName(relationshipField.getResourceInformation()), (Object)relationshipField.getUnderlyingName());
                ((ResourceFieldImpl)relationshipField).setLookupIncludeBehavior(LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL);
            } else if (relationshipField.getRelationshipRepositoryBehavior() == RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER) {
                LOGGER.debug("{}.{}: RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER enforces LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL to resolve relationship from opposite side", this.toShortName(relationshipField.getResourceInformation()), (Object)relationshipField.getUnderlyingName());
                ((ResourceFieldImpl)relationshipField).setLookupIncludeBehavior(LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL);
            } else if (relationshipField.getRelationshipRepositoryBehavior() == RelationshipRepositoryBehavior.CUSTOM) {
                LOGGER.debug("{}.{}: RelationshipRepositoryBehavior.CUSTOM enforces LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL to resolve relationship from custom repository", this.toShortName(relationshipField.getResourceInformation()), (Object)relationshipField.getUnderlyingName());
                ((ResourceFieldImpl)relationshipField).setLookupIncludeBehavior(LookupIncludeBehavior.AUTOMATICALLY_WHEN_NULL);
            } else {
                LOGGER.debug("{}.{}: fall back to LookupIncludeBehavior.NONE", this.toShortName(relationshipField.getResourceInformation()), (Object)relationshipField.getUnderlyingName());
                ((ResourceFieldImpl)relationshipField).setLookupIncludeBehavior(LookupIncludeBehavior.NONE);
            }
        }
        return match;
    }

    private MatchedRelationship findRelationshipMatch(ResourceField relationshipField) {
        MatchedRelationship matchedEntry = null;
        for (Object repository : this.moduleRegistry.getRepositories()) {
            RelationshipRepositoryInformation relationshipRepositoryInformation;
            RelationshipMatcher matcher;
            RepositoryInformation repositoryInformation = this.moduleRegistry.getRepositoryInformation(repository);
            if (!(repositoryInformation instanceof RelationshipRepositoryInformation) || !(matcher = (relationshipRepositoryInformation = (RelationshipRepositoryInformation)repositoryInformation).getMatcher()).matches(relationshipField)) continue;
            if (matchedEntry != null) {
                throw new IllegalStateException("multiple repositories for " + relationshipField + ": " + repository + ", " + matchedEntry);
            }
            matcher.matches(relationshipField);
            matchedEntry = new MatchedRelationship(relationshipField, relationshipRepositoryInformation, repository);
        }
        return matchedEntry;
    }

    private ResourceInformation buildResource() {
        ResourceInformation resourceInformation = this.resource.build();
        DefaultRegistryEntryBuilder.contributeFields(this.moduleRegistry, resourceInformation);
        return resourceInformation;
    }

    public static void contributeFields(final ModuleRegistry moduleRegistry, final ResourceInformation resourceInformation) {
        ArrayList<ResourceFieldContributor> contributors = new ArrayList<ResourceFieldContributor>();
        contributors.addAll(moduleRegistry.getResourceFieldContributors());
        for (Object repo : moduleRegistry.getRepositories()) {
            if (!(repo instanceof ResourceFieldContributor) || contributors.contains(repo)) continue;
            contributors.add((ResourceFieldContributor)repo);
        }
        for (ResourceFieldContributor contributor : contributors) {
            List<ResourceField> contributedFields = contributor.getResourceFields(new ResourceFieldContributorContext(){

                @Override
                public ResourceInformation getResourceInformation() {
                    return resourceInformation;
                }

                @Override
                public InformationBuilder getInformationBuilder() {
                    return new DefaultInformationBuilder(moduleRegistry.getTypeParser());
                }
            });
            ArrayList<ResourceField> fields = new ArrayList<ResourceField>();
            fields.addAll(resourceInformation.getFields());
            fields.addAll(contributedFields);
            resourceInformation.setFields(fields);
        }
    }

    private Object buildResourceRepository(ResourceInformation resourceInformation) {
        this.resourceRepository.information().setResourceInformation(resourceInformation);
        ResourceRepositoryInformation repositoryInformation = this.resourceRepository.information().build();
        Object instance = this.resourceRepository.instance;
        return this.decorateRepository(instance);
    }

    private MatchedRelationship setupForwardingRepository(ResourceField relationshipField) {
        ForwardingRelationshipRepository repository;
        ResourceInformation sourceInformation = relationshipField.getResourceInformation();
        RelationshipRepositoryBehavior behavior = relationshipField.getRelationshipRepositoryBehavior();
        if (behavior == RelationshipRepositoryBehavior.DEFAULT) {
            if (relationshipField.hasIdField()) {
                behavior = RelationshipRepositoryBehavior.FORWARD_OWNER;
                LOGGER.debug("{}.{}: choosing default RelationshipRepositoryBehavior: relationId field enforces FORWARD_OWNER", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
            } else if (relationshipField.isMappedBy()) {
                LOGGER.debug("{}.{}: choosing default RelationshipRepositoryBehavior: mappedBy enforces FORWARD_OPPOSITE", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
                behavior = RelationshipRepositoryBehavior.FORWARD_OPPOSITE;
            } else if (relationshipField.getLookupIncludeBehavior() == LookupIncludeBehavior.NONE) {
                LOGGER.debug("{}.{}: choosing default RelationshipRepositoryBehavior: NONE lookup behavior enforces FORWARD_OWNER", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
                behavior = RelationshipRepositoryBehavior.FORWARD_OWNER;
            } else if (relationshipField.getLookupIncludeBehavior() == LookupIncludeBehavior.DEFAULT) {
                LOGGER.debug("{}.{}: choosing default RelationshipRepositoryBehavior: default fallback to FORWARD_OWNER, no custom repository nor custom configuration", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
                behavior = RelationshipRepositoryBehavior.FORWARD_OWNER;
            } else {
                if (FAIL_ON_MISSING_REPOSITORY) {
                    throw new IllegalStateException("no relationship repository available for " + relationshipField + ", provide a custom relationship reposit implementation, add a @JsonApiRelationId field, use @JsonApiRelation.mappedBy, set @JsonApiRelation.repositoryBehavior or set @JsonApiRelation.LOOKUP to NONE");
                }
                return null;
            }
            ((ResourceFieldImpl)relationshipField).setRelationshipRepositoryBehavior(behavior);
        }
        if (behavior == RelationshipRepositoryBehavior.CUSTOM) {
            throw new IllegalStateException("RelationshipRepositoryBehavior.CUSTOM used for " + relationshipField + " but no implementation provided");
        }
        if (behavior == RelationshipRepositoryBehavior.FORWARD_OPPOSITE || behavior == RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER) {
            PreconditionUtil.verify(relationshipField.getOppositeName() != null, "field %s must specify @JsonApiRelation.opposite to make use of opposite forwarding behavior.", relationshipField.getUnderlyingName());
        }
        ResourceFieldAccess fieldAccess = relationshipField.getAccess();
        RepositoryMethodAccess access = new RepositoryMethodAccess(fieldAccess.isPostable(), fieldAccess.isPatchable(), fieldAccess.isReadable(), fieldAccess.isPatchable());
        RelationshipMatcher matcher = new RelationshipMatcher().rule().field(relationshipField).add();
        RelationshipRepositoryInformationImpl implicitRepoInformation = new RelationshipRepositoryInformationImpl(matcher, access);
        if (behavior == RelationshipRepositoryBehavior.FORWARD_OWNER) {
            LOGGER.debug("{}.{}: setting up owner/owner forwarding repository", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
            repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OWNER, ForwardingDirection.OWNER);
        } else if (behavior == RelationshipRepositoryBehavior.FORWARD_GET_OPPOSITE_SET_OWNER) {
            LOGGER.debug("{}.{}: setting up opposite/owner forwarding repository", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
            repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OPPOSITE, ForwardingDirection.OWNER);
        } else {
            LOGGER.debug("{}.{}: setting up opposite/opposite forwarding repository", this.toShortName(sourceInformation), (Object)relationshipField.getUnderlyingName());
            PreconditionUtil.verifyEquals((Object)RelationshipRepositoryBehavior.FORWARD_OPPOSITE, (Object)behavior, "unknown behavior for field=%s", relationshipField);
            repository = new ForwardingRelationshipRepository(sourceInformation.getResourceType(), matcher, ForwardingDirection.OPPOSITE, ForwardingDirection.OPPOSITE);
        }
        repository.setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        repository.setHttpRequestContextProvider(this.moduleRegistry.getHttpRequestContextProvider());
        return new MatchedRelationship(relationshipField, implicitRepoInformation, repository);
    }

    private Object toShortName(ResourceInformation information) {
        Class<?> resourceClass = information.getResourceClass();
        return resourceClass != Resource.class ? resourceClass.getName() : information.getResourceType();
    }

    public Object decorateRepository(Object repository) {
        if (repository instanceof ResourceRegistryAware) {
            ((ResourceRegistryAware)repository).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        Object decoratedRepository = repository;
        List<RepositoryDecoratorFactory> repositoryDecorators = this.moduleRegistry.getRepositoryDecoratorFactories();
        for (RepositoryDecoratorFactory repositoryDecorator : repositoryDecorators) {
            decoratedRepository = repositoryDecorator.decorateRepository(decoratedRepository);
            if (!(decoratedRepository instanceof ResourceRegistryAware)) continue;
            ((ResourceRegistryAware)decoratedRepository).setResourceRegistry(this.moduleRegistry.getResourceRegistry());
        }
        return decoratedRepository;
    }

    private ResourceRepositoryAdapter buildResourceRepositoryAdapter(ResourceInformation resourceInformation) {
        if (this.resourceRepository == null) {
            return null;
        }
        this.resourceRepository.information().setResourceInformation(resourceInformation);
        ResourceRepositoryInformation repositoryInformation = this.resourceRepository.information().build();
        Object instance = this.resourceRepository.instance;
        Object decoratedRepository = this.decorateRepository(instance);
        List<RepositoryAdapterFactory> adapterFactories = this.moduleRegistry.getRepositoryAdapterFactories();
        ResourceRepositoryAdapter adapter = null;
        for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
            if (!adapterFactory.accepts(decoratedRepository)) continue;
            adapter = adapterFactory.createResourceRepositoryAdapter(repositoryInformation, decoratedRepository);
            break;
        }
        if (adapter == null) {
            throw new IllegalStateException("no RepositoryAdapterFactory found for " + decoratedRepository + ", make sure it is a valid repository, e.g. by implementing ResourceRepository");
        }
        for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
            adapter = adapterFactory.decorate(adapter);
        }
        return adapter;
    }

    class MatchedRelationship {
        private final ResourceField relationshipField;
        private final RelationshipRepositoryInformation relationshipRepositoryInformation;
        private final Object relRepository;

        public MatchedRelationship(ResourceField relationshipField, RelationshipRepositoryInformation relationshipRepositoryInformation, Object relRepository) {
            this.relationshipField = relationshipField;
            this.relationshipRepositoryInformation = relationshipRepositoryInformation;
            this.relRepository = relRepository;
        }

        public String toString() {
            return this.relRepository.toString();
        }

        private RelationshipRepositoryAdapter getAdapter() {
            Object decoratedRepository = DefaultRegistryEntryBuilder.this.decorateRepository(this.relRepository);
            List<RepositoryAdapterFactory> adapterFactories = DefaultRegistryEntryBuilder.this.moduleRegistry.getRepositoryAdapterFactories();
            RelationshipRepositoryAdapter adapter = null;
            for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
                if (!adapterFactory.accepts(decoratedRepository)) continue;
                adapter = adapterFactory.createRelationshipRepositoryAdapter(this.relationshipField, this.relationshipRepositoryInformation, decoratedRepository);
                break;
            }
            if (adapter == null) {
                throw new IllegalStateException("no RepositoryAdapterFactory found for " + decoratedRepository + ", make sure it is a valid repository, e.g. by implementing ResourceRepository");
            }
            for (RepositoryAdapterFactory adapterFactory : adapterFactories) {
                adapter = adapterFactory.decorate(adapter);
            }
            return adapter;
        }
    }

    class DefaultRelationshipRepository
    implements RegistryEntryBuilder.RelationshipRepositoryEntryBuilder {
        private final String fieldName;
        private InformationBuilder.RelationshipRepositoryInformationBuilder information;
        private Object instance;

        public DefaultRelationshipRepository(String fieldName) {
            this.fieldName = fieldName;
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createRelationshipRepository(null);
        }

        @Override
        public InformationBuilder.RelationshipRepositoryInformationBuilder information() {
            return this.information;
        }

        @Override
        public void instance(MatchedRelationshipRepository instance) {
            this.instance = instance;
        }
    }

    class DefaultResourceRepository
    implements RegistryEntryBuilder.ResourceRepositoryEntryBuilder {
        private Object instance;
        private InformationBuilder.ResourceRepositoryInformationBuilder information;

        public DefaultResourceRepository() {
            this.information = DefaultRegistryEntryBuilder.this.informationBuilder.createResourceRepository();
        }

        @Override
        public InformationBuilder.ResourceRepositoryInformationBuilder information() {
            return this.information;
        }

        @Override
        public void instance(Object instance) {
            this.instance = instance;
        }
    }
}

