/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.information;

import io.crnk.core.engine.information.InformationBuilder;
import io.crnk.core.engine.information.repository.RelationshipRepositoryInformation;
import io.crnk.core.engine.information.repository.RepositoryAction;
import io.crnk.core.engine.information.repository.RepositoryMethodAccess;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.EmbeddableInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.information.resource.ResourceValidator;
import io.crnk.core.engine.information.resource.VersionRange;
import io.crnk.core.engine.internal.information.repository.RelationshipRepositoryInformationImpl;
import io.crnk.core.engine.internal.information.repository.ResourceRepositoryInformationImpl;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.repository.RelationshipMatcher;
import io.crnk.core.resource.annotations.JsonApiResource;
import io.crnk.core.resource.annotations.JsonIncludeStrategy;
import io.crnk.core.resource.annotations.LookupIncludeBehavior;
import io.crnk.core.resource.annotations.PatchStrategy;
import io.crnk.core.resource.annotations.RelationshipRepositoryBehavior;
import io.crnk.core.resource.annotations.SerializeType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultInformationBuilder
implements InformationBuilder {
    private final TypeParser typeParser;

    @Override
    public InformationBuilder.FieldInformationBuilder createResourceField() {
        return new DefaultField();
    }

    @Override
    public InformationBuilder.RelationshipRepositoryInformationBuilder createRelationshipRepository(String sourceResourceType, String targetResourceType) {
        RelationshipMatcher matcher = new RelationshipMatcher();
        matcher.rule().target(targetResourceType).source(sourceResourceType).add();
        return this.createRelationshipRepository(matcher);
    }

    @Override
    public InformationBuilder.RelationshipRepositoryInformationBuilder createRelationshipRepository(RelationshipMatcher matcher) {
        DefaultRelationshipRepository repository = new DefaultRelationshipRepository();
        repository.matcher = matcher;
        return repository;
    }

    @Override
    public InformationBuilder.ResourceRepositoryInformationBuilder createResourceRepository() {
        return new DefaultResourceRepository();
    }

    @Override
    public InformationBuilder.ResourceInformationBuilder createResource(Class<?> resourceClass, String resourceType) {
        return this.createResource(resourceClass, resourceType, null);
    }

    @Override
    public InformationBuilder.ResourceInformationBuilder createResource(Class<?> resourceClass, String resourceType, String resourcePath) {
        DefaultResource resource = new DefaultResource();
        resource.implementationType(resourceClass);
        resource.resourceType(resourceType);
        resource.resourcePath(resourcePath);
        return resource;
    }

    public DefaultInformationBuilder(TypeParser typeParser) {
        this.typeParser = typeParser;
    }

    public class DefaultField
    implements InformationBuilder.FieldInformationBuilder {
        private String jsonName;
        private String underlyingName;
        private Class<?> type;
        private Type genericType;
        private String oppositeResourceType = null;
        private LookupIncludeBehavior lookupIncludeBehavior = LookupIncludeBehavior.DEFAULT;
        private ResourceFieldType fieldType = ResourceFieldType.ATTRIBUTE;
        private SerializeType serializeType = SerializeType.LAZY;
        private JsonIncludeStrategy jsonIncludeStrategy = JsonIncludeStrategy.DEFAULT;
        private VersionRange versionRange = VersionRange.UNBOUNDED;
        private String oppositeName;
        private ResourceFieldAccessor accessor;
        private String idName;
        private Class idType;
        private ResourceFieldAccessor idAccessor;
        private ResourceFieldAccess access = new ResourceFieldAccess(true, true, true, true, true, true);
        private RelationshipRepositoryBehavior relationshipRepositoryBehavior = RelationshipRepositoryBehavior.DEFAULT;
        private PatchStrategy patchStrategy = PatchStrategy.DEFAULT;
        private boolean mappedBy;
        private DefaultEmbeddableInformation embeddedTypeBuilder;

        @Override
        public void from(ResourceField field) {
            this.jsonName = field.getJsonName();
            this.underlyingName = field.getUnderlyingName();
            this.type = field.getType();
            this.genericType = field.getGenericType();
            this.fieldType = field.getResourceFieldType();
            this.accessor = field.getAccessor();
            this.access = field.getAccess();
            this.serializeType = field.getSerializeType();
            this.jsonIncludeStrategy = field.getJsonIncludeStrategy();
            this.versionRange = field.getVersionRange();
            this.mappedBy = field.isMappedBy();
            this.embeddedTypeBuilder = this.toBuilder(field.getEmbeddedType());
            if (this.fieldType == ResourceFieldType.RELATIONSHIP) {
                this.relationshipRepositoryBehavior = field.getRelationshipRepositoryBehavior();
                this.oppositeResourceType = field.getOppositeResourceType();
                this.lookupIncludeBehavior = field.getLookupIncludeBehavior();
                this.oppositeName = field.getOppositeName();
                if (field.hasIdField()) {
                    this.idName = field.getIdName();
                    this.idType = field.getIdType();
                    this.idAccessor = field.getIdAccessor();
                }
            }
            this.patchStrategy = field.getPatchStrategy();
        }

        private DefaultEmbeddableInformation toBuilder(EmbeddableInformation type) {
            if (type == null) {
                return null;
            }
            this.embeddedTypeBuilder = new DefaultEmbeddableInformation();
            this.embeddedTypeBuilder.implementationType(type.getImplementationType());
            for (ResourceField field : type.getFields()) {
                this.embeddedTypeBuilder.addField().from(field);
            }
            return this.embeddedTypeBuilder;
        }

        @Override
        public ResourceField build() {
            Class<?> elementType;
            JsonApiResource annotation;
            if (this.oppositeResourceType == null && this.fieldType == ResourceFieldType.RELATIONSHIP && (annotation = (elementType = ClassUtils.getRawType(ClassUtils.getElementType(this.genericType))).getAnnotation(JsonApiResource.class)) != null) {
                this.oppositeResourceType = annotation.type();
            }
            ResourceFieldImpl impl = new ResourceFieldImpl(this.jsonName, this.underlyingName, this.fieldType, this.type, this.genericType, this.oppositeResourceType, this.oppositeName, this.serializeType, this.jsonIncludeStrategy, this.lookupIncludeBehavior, this.access, this.idName, this.idType, this.idAccessor, this.relationshipRepositoryBehavior, this.patchStrategy);
            impl.setMappedBy(this.mappedBy);
            impl.setVersionRange(this.versionRange);
            if (this.embeddedTypeBuilder != null) {
                impl.setEmbeddedType(this.embeddedTypeBuilder.build());
            }
            if (this.accessor != null) {
                impl.setAccessor(this.accessor);
            }
            return impl;
        }

        @Override
        public DefaultField name(String name) {
            this.jsonName = name;
            this.underlyingName = name;
            return this;
        }

        @Override
        public DefaultField relationshipRepositoryBehavior(RelationshipRepositoryBehavior relationshipRepositoryBehavior) {
            this.relationshipRepositoryBehavior = relationshipRepositoryBehavior;
            return this;
        }

        @Override
        public DefaultField jsonName(String jsonName) {
            this.jsonName = jsonName;
            return this;
        }

        @Override
        public DefaultField underlyingName(String underlyingName) {
            this.underlyingName = underlyingName;
            return this;
        }

        @Override
        public DefaultField type(Class<?> type) {
            this.type = type;
            if (this.genericType == null) {
                this.genericType = type;
            }
            return this;
        }

        @Override
        public InformationBuilder.EmbeddableInformationBuilder embeddedType(Class<?> type) {
            if (this.genericType == null) {
                this.genericType(type);
            }
            if (this.embeddedTypeBuilder == null) {
                this.embeddedTypeBuilder = new DefaultEmbeddableInformation();
                this.embeddedTypeBuilder.implementationType(type);
            }
            return this.embeddedTypeBuilder;
        }

        @Override
        public DefaultField genericType(Type genericType) {
            this.genericType = genericType;
            if (this.type == null) {
                this.type = ClassUtils.getRawType(genericType);
            }
            return this;
        }

        @Override
        public DefaultField serializeType(SerializeType serializeType) {
            this.serializeType = serializeType;
            return this;
        }

        @Override
        public InformationBuilder.FieldInformationBuilder jsonIncludeStrategy(JsonIncludeStrategy jsonIncludeStrategy) {
            this.jsonIncludeStrategy = jsonIncludeStrategy;
            return this;
        }

        @Override
        public DefaultField oppositeResourceType(String oppositeResourceType) {
            this.oppositeResourceType = oppositeResourceType;
            return this;
        }

        @Override
        public DefaultField lookupIncludeBehavior(LookupIncludeBehavior lookupIncludeBehavior) {
            this.lookupIncludeBehavior = lookupIncludeBehavior;
            return this;
        }

        @Override
        public DefaultField fieldType(ResourceFieldType fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public DefaultField oppositeName(String oppositeName) {
            this.oppositeName = oppositeName;
            return this;
        }

        @Override
        public DefaultField accessor(ResourceFieldAccessor accessor) {
            this.accessor = accessor;
            return this;
        }

        @Override
        public DefaultField idAccessor(ResourceFieldAccessor idAccessor) {
            this.idAccessor = idAccessor;
            return this;
        }

        @Override
        public DefaultField idName(String idName) {
            this.idName = idName;
            return this;
        }

        @Override
        public DefaultField idType(Class idType) {
            this.idType = idType;
            return this;
        }

        @Override
        public InformationBuilder.FieldInformationBuilder patchStrategy(PatchStrategy patchStrategy) {
            this.patchStrategy = patchStrategy;
            return this;
        }

        @Override
        public InformationBuilder.FieldInformationBuilder setMappedBy(boolean mappedBy) {
            this.mappedBy = mappedBy;
            return this;
        }

        @Override
        public InformationBuilder.FieldInformationBuilder versionRange(VersionRange versionRange) {
            this.versionRange = versionRange;
            return this;
        }

        @Override
        public DefaultField access(ResourceFieldAccess access) {
            this.access = access;
            return this;
        }
    }

    public class DefaultEmbeddableInformation
    implements InformationBuilder.EmbeddableInformationBuilder {
        private Type implementationType;
        private List<DefaultField> fields = new ArrayList<DefaultField>();

        public EmbeddableInformation build() {
            EmbeddableInformation information = new EmbeddableInformation(this.implementationType, this.fields.stream().map(it -> it.build()).collect(Collectors.toList()));
            return information;
        }

        @Override
        public void from(EmbeddableInformation information) {
            this.implementationType = information.getImplementationType();
            for (ResourceField fromField : information.getFields()) {
                DefaultField field = new DefaultField();
                field.from(fromField);
                this.fields.add(field);
            }
        }

        @Override
        public DefaultField addField() {
            DefaultField field = new DefaultField();
            this.fields.add(field);
            return field;
        }

        @Override
        public DefaultField addField(String name, ResourceFieldType type, Class<?> clazz) {
            DefaultField field = new DefaultField();
            field.jsonName(name);
            field.underlyingName(name);
            field.type((Class)clazz);
            field.genericType(clazz);
            field.fieldType(type);
            this.fields.add(field);
            return field;
        }

        @Override
        public InformationBuilder.EmbeddableInformationBuilder implementationType(Type implementationType) {
            this.implementationType = implementationType;
            return this;
        }
    }

    public class DefaultResource
    implements InformationBuilder.ResourceInformationBuilder {
        private List<DefaultField> fields = new ArrayList<DefaultField>();
        private Type implementationType;
        private String resourceType;
        private String resourcePath;
        private String superResourceType;
        private StringMapper idStringMapper;
        private ResourceValidator validator;
        private Class<? extends PagingSpec> pagingSpecType;
        private VersionRange versionRange = VersionRange.UNBOUNDED;
        private ResourceFieldAccess access = new ResourceFieldAccess(true, true, true, true, true, true);

        @Override
        public void from(ResourceInformation information) {
            this.implementationType = information.getImplementationType();
            this.resourceType = information.getResourceType();
            this.resourcePath = information.getResourcePath();
            this.superResourceType = information.getSuperResourceType();
            this.idStringMapper = information.getIdStringMapper();
            this.validator = information.getValidator();
            this.access = information.getAccess();
            this.versionRange = information.getVersionRange();
            for (ResourceField fromField : information.getFields()) {
                DefaultField field = new DefaultField();
                field.from(fromField);
                this.fields.add(field);
            }
            this.pagingSpecType = information.getPagingSpecType();
        }

        @Override
        public void setAccess(ResourceFieldAccess access) {
            this.access = access;
        }

        @Override
        public DefaultField addField() {
            DefaultField field = new DefaultField();
            this.fields.add(field);
            return field;
        }

        @Override
        public DefaultField addField(String name, ResourceFieldType type, Class<?> clazz) {
            DefaultField field = new DefaultField();
            field.jsonName(name);
            field.underlyingName(name);
            field.type((Class)clazz);
            field.genericType(clazz);
            field.fieldType(type);
            this.fields.add(field);
            return field;
        }

        @Override
        public DefaultResource implementationType(Type implementationType) {
            this.implementationType = implementationType;
            return this;
        }

        @Override
        public DefaultResource resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public DefaultResource resourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
            return this;
        }

        @Override
        public DefaultResource superResourceType(String superResourceType) {
            this.superResourceType = superResourceType;
            return this;
        }

        @Override
        public InformationBuilder.ResourceInformationBuilder pagingSpecType(Class<? extends PagingSpec> pagingSpecType) {
            this.pagingSpecType = pagingSpecType;
            return this;
        }

        @Override
        public InformationBuilder.ResourceInformationBuilder versionRange(VersionRange versionRange) {
            this.versionRange = versionRange;
            return this;
        }

        @Override
        public ResourceInformation build() {
            ArrayList<ResourceField> fieldImpls = new ArrayList<ResourceField>();
            for (DefaultField field : this.fields) {
                fieldImpls.add(field.build());
            }
            ResourceInformation information = new ResourceInformation(DefaultInformationBuilder.this.typeParser, this.implementationType, this.resourceType, this.resourcePath, this.superResourceType, fieldImpls, this.pagingSpecType);
            information.setAccess(this.access);
            information.setVersionRange(this.versionRange);
            if (this.validator != null) {
                information.setValidator(this.validator);
            }
            if (this.idStringMapper != null) {
                information.setIdStringMapper(this.idStringMapper);
            }
            return information;
        }
    }

    public class DefaultResourceRepository
    implements InformationBuilder.ResourceRepositoryInformationBuilder {
        private ResourceInformation resourceInformation;
        private Map<String, RepositoryAction> actions = new HashMap<String, RepositoryAction>();
        private RepositoryMethodAccess access = new RepositoryMethodAccess(true, true, true, true);
        private boolean exposed = true;

        @Override
        public void from(ResourceRepositoryInformation information) {
            this.actions.putAll(information.getActions());
            this.access = information.getAccess();
            this.exposed = information.isExposed();
            if (information.getResourceInformation().isPresent()) {
                this.resourceInformation = information.getResourceInformation().get();
            }
        }

        @Override
        public void setResourceInformation(ResourceInformation resourceInformation) {
            this.resourceInformation = resourceInformation;
        }

        @Override
        public void setAccess(RepositoryMethodAccess access) {
            this.access = access;
        }

        @Override
        public void setExposed(boolean exposed) {
            this.exposed = exposed;
        }

        @Override
        public ResourceRepositoryInformation build() {
            return new ResourceRepositoryInformationImpl(this.resourceInformation.getResourceType(), this.resourceInformation, this.actions, this.access, this.exposed);
        }
    }

    public class DefaultRelationshipRepository
    implements InformationBuilder.RelationshipRepositoryInformationBuilder {
        private RelationshipMatcher matcher;
        private RepositoryMethodAccess access = new RepositoryMethodAccess(true, true, true, true);

        @Override
        public void setAccess(RepositoryMethodAccess access) {
            this.access = access;
        }

        @Override
        public RelationshipRepositoryInformation build() {
            return new RelationshipRepositoryInformationImpl(this.matcher, this.access);
        }
    }
}

