/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.path.ActionPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.http.DocumentFilterChainImpl;
import io.crnk.core.engine.internal.http.DocumentFilterContextImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessorBase;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.result.ImmediateResultFactory;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.module.Module;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonApiRequestProcessor
extends JsonApiRequestProcessorBase
implements HttpRequestProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonApiRequestProcessor.class);

    public JsonApiRequestProcessor(Module.ModuleContext moduleContext) {
        super(moduleContext);
    }

    public static boolean matchesContentTypeHeader(HttpRequestContext requestContext, boolean acceptPlainJson) {
        String contentType;
        String method = requestContext.getMethod().toUpperCase();
        boolean isPatch = method.equals(HttpMethod.PATCH.toString());
        boolean isPost = method.equals(HttpMethod.POST.toString());
        if (!(!isPatch && !isPost || (contentType = requestContext.getRequestHeader("Content-Type")) != null && contentType.startsWith("application/vnd.api+json"))) {
            LOGGER.debug("not a JSON-API request due to content type {}", (Object)contentType);
            return false;
        }
        return true;
    }

    public static boolean matchesAcceptHeader(HttpRequestContext requestContext, boolean acceptPlainJson) {
        boolean acceptsJsonApi = requestContext.accepts("application/vnd.api+json");
        boolean acceptsAny = acceptsJsonApi || requestContext.acceptsAny();
        boolean acceptsPlainJson = acceptsAny || acceptPlainJson && requestContext.accepts("application/json");
        LOGGER.debug("HTTP Accept header matches: {}", (Object)acceptPlainJson);
        return acceptsPlainJson;
    }

    public static boolean isJsonApiRequest(HttpRequestContext requestContext, boolean acceptPlainJson) {
        return JsonApiRequestProcessor.matchesContentTypeHeader(requestContext, acceptPlainJson) && JsonApiRequestProcessor.matchesAcceptHeader(requestContext, acceptPlainJson);
    }

    @Override
    public boolean supportsAsync() {
        return true;
    }

    @Override
    public boolean accepts(HttpRequestContext context) {
        boolean acceptingPlainJson = this.isAcceptingPlainJson();
        boolean acceptHeaderMatch = JsonApiRequestProcessor.matchesAcceptHeader(context, acceptingPlainJson);
        if (acceptHeaderMatch) {
            boolean contentTypeHeaderMatch = JsonApiRequestProcessor.matchesContentTypeHeader(context, acceptingPlainJson);
            JsonPath jsonPath = this.helper.getJsonPath(context);
            if (jsonPath == null) {
                LOGGER.debug("not accepted since no matching repository defined for path={}", (Object)context.getPath());
                return false;
            }
            if (!contentTypeHeaderMatch) {
                LOGGER.warn("not accepted due to content-type header mismatch, application/vnd.api+json missing?");
                return false;
            }
            LOGGER.debug("accepted to server request: path={}", (Object)jsonPath);
            return true;
        }
        return false;
    }

    @Override
    public Result<HttpResponse> processAsync(HttpRequestContext requestContext) {
        Result<HttpResponse> response = this.checkMethod(requestContext);
        if (response != null) {
            return response;
        }
        String method = requestContext.getMethod();
        ResultFactory resultFactory = this.moduleContext.getResultFactory();
        JsonPath jsonPath = this.helper.getJsonPath(requestContext);
        LOGGER.debug("processing JSON API request path={}, method={}", (Object)jsonPath, (Object)method);
        Map<String, Set<String>> parameters = requestContext.getRequestParameters();
        if (jsonPath instanceof ActionPath) {
            String path = requestContext.getPath();
            RequestDispatcher requestDispatcher = this.moduleContext.getRequestDispatcher();
            requestDispatcher.dispatchAction(path, method, parameters);
            return null;
        }
        if (jsonPath != null) {
            Document requestDocument;
            try {
                requestDocument = this.getRequestDocument(requestContext);
            }
            catch (JsonProcessingException e) {
                return resultFactory.just(this.getErrorResponse(e));
            }
            QueryContext queryContext = requestContext.getQueryContext();
            return this.processAsync(jsonPath, method, parameters, requestDocument, queryContext).map(this::toHttpResponse);
        }
        return resultFactory.just(this.buildMethodNotAllowedResponse(method));
    }

    private Result<HttpResponse> checkMethod(HttpRequestContext requestContext) {
        boolean acceptsMethod;
        String method = requestContext.getMethod();
        boolean isPatch = method.equals(HttpMethod.PATCH.toString());
        boolean isPost = method.equals(HttpMethod.POST.toString());
        boolean isGet = method.equals(HttpMethod.GET.toString());
        boolean isDelete = method.equals(HttpMethod.DELETE.toString());
        boolean bl = acceptsMethod = isGet || isDelete || isPatch || isPost;
        if (!acceptsMethod) {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            return resultFactory.just(this.buildMethodNotAllowedResponse(method));
        }
        return null;
    }

    public Result<Response> processAsync(JsonPath jsonPath, String method, Map<String, Set<String>> parameters, Document requestDocument, QueryContext queryContext) {
        try {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            QueryAdapter queryAdapter = this.helper.toQueryAdapter(parameters, jsonPath, queryContext);
            LOGGER.debug("using requestVersion={}", (Object)queryContext.getRequestVersion());
            if (resultFactory instanceof ImmediateResultFactory) {
                LOGGER.debug("processing synchronously");
                DocumentFilterContextImpl filterContext = new DocumentFilterContextImpl(jsonPath, queryAdapter, requestDocument, method);
                try {
                    DocumentFilterChain filterChain = this.getFilterChain(jsonPath, method);
                    Response response = filterChain.doFilter(filterContext);
                    return resultFactory.just(response);
                }
                catch (Exception e) {
                    Response response = this.toErrorResponse(e);
                    return resultFactory.just(response);
                }
            }
            LOGGER.debug("processing asynchronously");
            ControllerRegistry controllerRegistry = this.moduleContext.getModuleRegistry().getControllerRegistry();
            Controller controller = controllerRegistry.getController(jsonPath, method);
            Result<Response> responseResult = controller.handleAsync(jsonPath, queryAdapter, requestDocument);
            return responseResult.onErrorResume(this::toErrorResponse);
        }
        catch (Exception e) {
            ResultFactory resultFactory = this.moduleContext.getResultFactory();
            return resultFactory.just(this.toErrorResponse(e));
        }
    }

    private Response toErrorResponse(Throwable e) {
        return this.moduleContext.getExceptionMapperRegistry().toErrorResponse(e);
    }

    protected DocumentFilterChain getFilterChain(JsonPath jsonPath, String method) {
        ControllerRegistry controllerRegistry = this.moduleContext.getModuleRegistry().getControllerRegistry();
        Controller controller = controllerRegistry.getController(jsonPath, method);
        return new DocumentFilterChainImpl(this.moduleContext, controller);
    }
}

