/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import io.crnk.core.engine.dispatcher.RequestDispatcher;
import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.DocumentFilterChain;
import io.crnk.core.engine.filter.DocumentFilterContext;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpRequestContextProvider;
import io.crnk.core.engine.http.HttpRequestProcessor;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.PathBuilder;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.DocumentFilterContextImpl;
import io.crnk.core.engine.internal.http.HttpRequestContextBaseAdapter;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessor;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.result.ImmediateResult;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.ModuleRegistry;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestDispatcherImpl
implements RequestDispatcher {
    private final ExceptionMapperRegistry exceptionMapperRegistry;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ModuleRegistry moduleRegistry;

    public HttpRequestDispatcherImpl(ModuleRegistry moduleRegistry, ExceptionMapperRegistry exceptionMapperRegistry) {
        this.moduleRegistry = moduleRegistry;
        this.exceptionMapperRegistry = exceptionMapperRegistry;
        this.moduleRegistry.setRequestDispatcher(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Result<HttpResponse>> process(HttpRequestContextBase requestContextBase) throws IOException {
        HttpRequestContext requestContext = requestContextBase instanceof HttpRequestContext ? (HttpRequestContext)requestContextBase : new HttpRequestContextBaseAdapter(requestContextBase);
        QueryContext queryContext = requestContext.getQueryContext();
        HttpRequestContextProvider httpRequestContextProvider = this.moduleRegistry.getHttpRequestContextProvider();
        try {
            httpRequestContextProvider.onRequestStarted(requestContext);
            ServiceUrlProvider serviceUrlProvider = this.moduleRegistry.getResourceRegistry().getServiceUrlProvider();
            if (serviceUrlProvider != null) {
                queryContext.setBaseUrl(serviceUrlProvider.getUrl());
            }
            queryContext.setRequestPath(requestContext.getPath());
            List<HttpRequestProcessor> processors = this.moduleRegistry.getHttpRequestProcessors();
            PreconditionUtil.verify(!processors.isEmpty(), "no processors available", new Object[0]);
            for (HttpRequestProcessor processor : processors) {
                if (processor.supportsAsync()) {
                    if (!processor.accepts(requestContext)) continue;
                    this.logger.debug("using async processor {}", (Object)processor);
                    Result<HttpResponse> response = processor.processAsync(requestContext);
                    if (response == null) break;
                    response = httpRequestContextProvider.attach(response);
                    Optional<Result<HttpResponse>> optional = Optional.of(response.doWork(it -> requestContext.setResponse((HttpResponse)it)));
                    return optional;
                }
                this.logger.debug("using sync processor {}", (Object)processor);
                processor.process(requestContext);
                if (!requestContext.hasResponse()) continue;
                Optional<Result<HttpResponse>> optional = Optional.of(new ImmediateResult<HttpResponse>(requestContext.getResponse()));
                return optional;
            }
            this.logger.debug("no processor found for request {}", (Object)requestContextBase);
            Optional optional = Optional.empty();
            return optional;
        }
        finally {
            httpRequestContextProvider.onRequestFinished();
        }
    }

    @Override
    @Deprecated
    public Response dispatchRequest(String path, String method, Map<String, Set<String>> parameters, Document requestBody) {
        List<HttpRequestProcessor> processors = this.moduleRegistry.getHttpRequestProcessors();
        JsonApiRequestProcessor processor = (JsonApiRequestProcessor)processors.stream().filter(it -> it instanceof JsonApiRequestProcessor).findFirst().get();
        HttpRequestContext requestContext = this.moduleRegistry.getHttpRequestContextProvider().getRequestContext();
        QueryContext queryContext = requestContext.getQueryContext();
        PathBuilder pathBuilder = new PathBuilder(this.moduleRegistry.getResourceRegistry(), this.moduleRegistry.getTypeParser());
        JsonPath jsonPath = pathBuilder.build(path, queryContext);
        return processor.processAsync(jsonPath, method, parameters, requestBody, queryContext).get();
    }

    @Override
    public void dispatchAction(String path, String method, Map<String, Set<String>> parameters) {
        QueryContext queryContext = new QueryContext();
        PathBuilder pathBuilder = new PathBuilder(this.moduleRegistry.getResourceRegistry(), this.moduleRegistry.getTypeParser());
        JsonPath jsonPath = pathBuilder.build(path, queryContext);
        ActionFilterChain chain = new ActionFilterChain();
        DocumentFilterContextImpl context = new DocumentFilterContextImpl(jsonPath, null, null, method);
        chain.doFilter(context);
    }

    class ActionFilterChain
    implements DocumentFilterChain {
        protected int filterIndex = 0;

        ActionFilterChain() {
        }

        @Override
        public Response doFilter(DocumentFilterContext context) {
            List<DocumentFilter> filters = HttpRequestDispatcherImpl.this.moduleRegistry.getFilters();
            if (this.filterIndex == filters.size()) {
                return null;
            }
            DocumentFilter filter = filters.get(this.filterIndex);
            ++this.filterIndex;
            return filter.filter(context, this);
        }
    }
}

