/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.http;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.http.HttpRequestContextBase;
import io.crnk.core.engine.http.HttpResponse;
import io.crnk.core.engine.query.QueryContext;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class HttpRequestContextBaseAdapter
implements HttpRequestContext {
    private HttpRequestContextBase base;
    private boolean hasResponse;
    private Map<String, Object> requestAttributes = new ConcurrentHashMap<String, Object>();
    private QueryContext queryContext = new QueryContext();

    public HttpRequestContextBaseAdapter(HttpRequestContextBase base) {
        this.base = base;
        this.queryContext.setBaseUrl(base.getBaseUrl());
        this.queryContext.setAttributes(this.requestAttributes);
        this.queryContext.setRequestPath(base.getPath());
        this.queryContext.setRequestVersion(this.getRequestVersion());
        this.queryContext.setRequestContext(this);
    }

    private int getRequestVersion() {
        Optional<Integer> requestVersion;
        String acceptHeader = this.base.getRequestHeader("Accept");
        if (acceptHeader != null && (requestVersion = Arrays.stream(acceptHeader.split("\\;")).map(it -> it.replace(" ", "")).filter(it -> it.startsWith("version=")).map(it -> it.substring("version".length() + 1).trim()).map(it -> Integer.parseInt(it)).findFirst()).isPresent()) {
            return requestVersion.get();
        }
        Set<String> versions = this.base.getRequestParameters().get("version");
        if (versions != null) {
            return Integer.parseInt(versions.iterator().next());
        }
        return -1;
    }

    @Override
    public boolean hasResponse() {
        return this.hasResponse;
    }

    @Override
    public boolean accepts(String contentType) {
        String accept = this.getRequestHeader("Accept");
        if (accept == null) {
            return false;
        }
        for (String acceptElement : accept.split("\\,")) {
            if (!this.isCompatible(acceptElement = acceptElement.trim(), contentType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsAny() {
        String accept = this.getRequestHeader("Accept");
        return accept == null || this.accepts("*") || this.accepts("*/*");
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        if (type.isInstance(this.base)) {
            return (T)this.base;
        }
        return null;
    }

    @Override
    public Object getRequestAttribute(String name) {
        return this.requestAttributes.get(name);
    }

    @Override
    public void setRequestAttribute(String name, Object value) {
        this.requestAttributes.put(name, value);
    }

    @Override
    public QueryContext getQueryContext() {
        return this.queryContext;
    }

    protected boolean isCompatible(String accept, String contentType) {
        String acceptLower = accept.toLowerCase();
        if (accept.equals(contentType)) {
            return true;
        }
        if (acceptLower.startsWith(contentType) && acceptLower.length() > contentType.length()) {
            char c = acceptLower.charAt(contentType.length());
            return c == ' ' || c == ';';
        }
        return false;
    }

    @Override
    public Set<String> getRequestHeaderNames() {
        return this.base.getRequestHeaderNames();
    }

    @Override
    public String getRequestHeader(String name) {
        return this.base.getRequestHeader(name);
    }

    @Override
    public Map<String, Set<String>> getRequestParameters() {
        return this.base.getRequestParameters();
    }

    @Override
    public String getPath() {
        return this.base.getPath();
    }

    @Override
    public String getBaseUrl() {
        return this.base.getBaseUrl();
    }

    @Override
    public byte[] getRequestBody() {
        return this.base.getRequestBody();
    }

    @Override
    public String getMethod() {
        return this.base.getMethod();
    }

    @Override
    public URI getRequestUri() {
        return this.base.getRequestUri();
    }

    @Override
    public HttpResponse getResponse() {
        return this.base.getResponse();
    }

    @Override
    public void setResponse(HttpResponse response) {
        this.hasResponse = true;
        this.base.setResponse(response);
    }
}

