/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.exception;

import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.utils.Prioritizable;
import java.util.Objects;

final class ExceptionMapperType
implements Prioritizable {
    private final ExceptionMapper exceptionMapper;
    private final Class<? extends Throwable> exceptionClass;

    public ExceptionMapperType(Class<? extends Throwable> exceptionClass, ExceptionMapper exceptionMapper) {
        this.exceptionMapper = exceptionMapper;
        this.exceptionClass = exceptionClass;
        PreconditionUtil.verify(exceptionClass != null, "exceptionClass must not be null for mapper=%s", exceptionMapper);
    }

    public Class<? extends Throwable> getExceptionClass() {
        return this.exceptionClass;
    }

    public ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExceptionMapperType)) {
            return false;
        }
        ExceptionMapperType that = (ExceptionMapperType)o;
        return Objects.equals(this.exceptionMapper, that.exceptionMapper) && Objects.equals(this.exceptionClass, that.exceptionClass);
    }

    public int hashCode() {
        return Objects.hash(this.exceptionMapper, this.exceptionClass);
    }

    public String toString() {
        return "ExceptionMapperType[exceptionClass=" + this.exceptionClass.getName() + ", exceptionMapper=" + this.exceptionMapper + ']';
    }

    @Override
    public int getPriority() {
        if (this.exceptionMapper instanceof Prioritizable) {
            return ((Prioritizable)((Object)this.exceptionMapper)).getPriority();
        }
        return 0;
    }
}

