/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.path;

import io.crnk.core.engine.information.repository.RepositoryAction;
import io.crnk.core.engine.information.repository.ResourceRepositoryInformation;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.path.ActionPath;
import io.crnk.core.engine.internal.dispatcher.path.FieldPath;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.exception.BadRequestException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PathBuilder.class);
    public static final String SEPARATOR = "/";
    public static final String RELATIONSHIP_MARK = "relationships";
    private final ResourceRegistry resourceRegistry;
    private final TypeParser parser;

    public PathBuilder(ResourceRegistry resourceRegistry, TypeParser parser) {
        this.resourceRegistry = resourceRegistry;
        this.parser = parser;
    }

    private static List<Serializable> parseIds(String idsString, ResourceInformation resourceInformation) {
        String[] strPathIds = idsString.split(",|%2C");
        ArrayList<Serializable> pathIds = new ArrayList<Serializable>();
        for (String strPathId : strPathIds) {
            pathIds.add(resourceInformation.parseIdString(strPathId));
        }
        return pathIds;
    }

    private List<Serializable> parseNestedIds(String idsString, Serializable parentId, ResourceField parentField) {
        String[] strPathIds = idsString.split(",|%2C");
        ResourceInformation resourceInformation = parentField.getResourceInformation();
        Class<?> idType = resourceInformation.getIdField().getType();
        ResourceFieldAccessor nestedIdAccessor = resourceInformation.getChildIdAccessor();
        ResourceFieldAccessor parentIdAccessor = resourceInformation.getParentIdAccessor();
        ArrayList<Serializable> pathIds = new ArrayList<Serializable>();
        for (String strPathId : strPathIds) {
            Serializable nestedId = (Serializable)ClassUtils.newInstance(idType);
            Object childId = this.parser.parse(strPathId, nestedIdAccessor.getImplementationClass());
            parentIdAccessor.setValue(nestedId, parentId);
            nestedIdAccessor.setValue(nestedId, childId);
            pathIds.add(nestedId);
        }
        return pathIds;
    }

    private static String[] splitPath(String path) {
        if (path.startsWith(SEPARATOR)) {
            path = path.substring(1);
        }
        if (path.endsWith(SEPARATOR)) {
            // empty if block
        }
        return path.split(SEPARATOR);
    }

    public JsonPath build(String path, QueryContext queryContext) {
        String[] pathElements = PathBuilder.splitPath(path);
        if (pathElements.length == 0 || pathElements.length == 1 && "".equals(pathElements[0])) {
            LOGGER.debug("requested root path: {}", (Object)path);
            return null;
        }
        return this.parseResourcePath(new LinkedList<String>(Arrays.asList(pathElements)), queryContext);
    }

    private JsonPath parseResourcePath(LinkedList<String> pathElements, QueryContext queryContext) {
        RegistryEntry rootEntry = this.getRootEntry(pathElements);
        if (rootEntry == null) {
            return null;
        }
        if (pathElements.isEmpty()) {
            LOGGER.debug("resource path to root entry found: {}", (Object)rootEntry);
            return new ResourcePath(rootEntry, null);
        }
        Map<String, RepositoryAction> actions = rootEntry.getRepositoryInformation().getActions();
        if (actions.containsKey(pathElements.peek())) {
            String pathElement = pathElements.pop();
            return new ActionPath(rootEntry, null, pathElement);
        }
        return this.parseIdPath(rootEntry, pathElements, queryContext);
    }

    private JsonPath parseIdPath(RegistryEntry entry, LinkedList<String> pathElements, QueryContext queryContext) {
        String pathElement = pathElements.pop();
        List<Serializable> ids = PathBuilder.parseIds(pathElement, entry.getResourceInformation());
        return this.parseFieldPath(entry, ids, pathElements, queryContext);
    }

    private JsonPath parseFieldPath(RegistryEntry entry, List<Serializable> ids, LinkedList<String> pathElements, QueryContext queryContext) {
        List<Serializable> nestedIds;
        if (pathElements.isEmpty()) {
            LOGGER.debug("resource path for {} with ids {} found", (Object)entry, ids);
            return new ResourcePath(entry, ids);
        }
        Map<String, RepositoryAction> actions = entry.getRepositoryInformation().getActions();
        if (actions.containsKey(pathElements.peek())) {
            String pathElement = pathElements.pop();
            LOGGER.debug("action path {} for {} with ids {} found", new Object[]{pathElement, entry, ids});
            return new ActionPath(entry, ids, pathElement);
        }
        String fieldName = pathElements.pop();
        if (fieldName.equals(RELATIONSHIP_MARK)) {
            if (pathElements.isEmpty()) {
                throw new BadRequestException("invalid url, relationships fragment must be followed by name");
            }
            fieldName = pathElements.poll();
            ResourceField field = (entry = this.findSelfOrSubtypeByField(entry, fieldName, queryContext)).getResourceInformation().findFieldByJsonName(fieldName, queryContext.getRequestVersion());
            if (field == null) {
                throw new BadRequestException("invalid url, requested field not found: " + fieldName);
            }
            if (field.getResourceFieldType() != ResourceFieldType.RELATIONSHIP) {
                throw new BadRequestException("invalid url, requested field is not a relationship: " + fieldName);
            }
            if (!pathElements.isEmpty()) {
                throw new BadRequestException("invalid url, cannot add further url fragments after relationship name");
            }
            LOGGER.debug("relationship path {} for {} with ids {} found", new Object[]{field, entry, ids});
            return new RelationshipsPath(entry, ids, field);
        }
        ResourceField field = (entry = this.findSelfOrSubtypeByField(entry, fieldName, queryContext)).getResourceInformation().findFieldByJsonName(fieldName, queryContext.getRequestVersion());
        if (field == null) {
            throw new BadRequestException("field not found: " + fieldName);
        }
        if (pathElements.isEmpty()) {
            if (this.isNestedField(field) && !field.isCollection()) {
                RegistryEntry nestedEntry = this.getNestedEntry(field);
                ResourcePath path = new ResourcePath(nestedEntry, ids);
                path.addParentField(field);
                return path;
            }
            LOGGER.debug("field path {} for {} with ids {} found", new Object[]{field, entry, ids});
            return new FieldPath(entry, ids, field);
        }
        if (field.getResourceFieldType() != ResourceFieldType.RELATIONSHIP || field.getOppositeName() == null) {
            LOGGER.debug("cannot process field={} is not a relationship with an opposite field", (Object)field);
            throw new BadRequestException("invalid url, cannot add further url fragements after field");
        }
        RegistryEntry oppositeEntry = this.resourceRegistry.getEntry(field.getOppositeResourceType());
        ResourceInformation oppositeInformation = oppositeEntry.getResourceInformation();
        ResourceField oppositeField = oppositeInformation.findFieldByJsonName(field.getOppositeName(), queryContext.getRequestVersion());
        PreconditionUtil.verify(oppositeField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP, "expected opposite field {} of {} to be a relationship", oppositeField, field);
        if (!oppositeInformation.isNested()) {
            LOGGER.debug("cannot process field={} because opposite={} is not an nested resource", (Object)field, (Object)oppositeInformation);
            throw new BadRequestException("invalid url, cannot specify ID of related resource");
        }
        PreconditionUtil.verify(oppositeField != null, "nested resource must specify opposite on relationship from parent to child, got null for %s", field);
        if (field.isCollection()) {
            PreconditionUtil.verify(ids.size() == 1, "cannot follow multiple ids along nested path", new Object[0]);
            Serializable parentId = ids.get(0);
            String strNestedId = pathElements.poll();
            nestedIds = this.parseNestedIds(strNestedId, parentId, oppositeField);
        } else {
            nestedIds = ids;
        }
        JsonPath jsonPath = this.parseFieldPath(oppositeEntry, nestedIds, pathElements, queryContext);
        if (jsonPath != null) {
            jsonPath.addParentField(field);
        }
        return jsonPath;
    }

    private RegistryEntry findSelfOrSubtypeByField(RegistryEntry entry, String jsonName, QueryContext queryContext) {
        if (entry.getResourceInformation().findFieldByJsonName(jsonName, queryContext.getRequestVersion()) == null) {
            for (RegistryEntry someEntry : this.resourceRegistry.getEntries()) {
                ResourceInformation resourceInformation = someEntry.getResourceInformation();
                ResourceField field = resourceInformation.findFieldByJsonName(jsonName, queryContext.getRequestVersion());
                if (field == null || !someEntry.isParent(entry)) continue;
                RegistryEntry parentEntry = someEntry.getParentRegistryEntry();
                while (parentEntry != null && parentEntry.getResourceInformation().findFieldByJsonName(jsonName, queryContext.getRequestVersion()) != null) {
                    someEntry = parentEntry;
                    parentEntry = someEntry.getParentRegistryEntry();
                }
                return someEntry;
            }
        }
        return entry;
    }

    private boolean isNestedField(ResourceField field) {
        if (field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP) {
            RegistryEntry oppositeType = this.resourceRegistry.getEntry(field.getOppositeResourceType());
            String oppositeName = field.getOppositeName();
            PreconditionUtil.verify(oppositeType != null, "opposite type %s not found for %s", field.getOppositeResourceType(), field.getUnderlyingName());
            ResourceInformation oppositeResourceInformation = oppositeType.getResourceInformation();
            if (oppositeName != null && oppositeResourceInformation.isNested()) {
                return oppositeResourceInformation.getParentField().getUnderlyingName().equals(oppositeName);
            }
        }
        return false;
    }

    private RegistryEntry getNestedEntry(ResourceField field) {
        PreconditionUtil.verify(field.getResourceFieldType() == ResourceFieldType.RELATIONSHIP, "not a relationship", new Object[0]);
        RegistryEntry oppositeType = this.resourceRegistry.getEntry(field.getOppositeResourceType());
        ResourceInformation resourceInformation = oppositeType.getResourceInformation();
        PreconditionUtil.verify(resourceInformation.isNested(), "not a nested relationship", new Object[0]);
        return oppositeType;
    }

    private RegistryEntry getRootEntry(LinkedList<String> pathElements) {
        StringBuilder potentialResourcePath = new StringBuilder(pathElements.pop());
        while (true) {
            RegistryEntry matchedEntry;
            if ((matchedEntry = this.getEntryByPath(potentialResourcePath.toString())) != null) {
                LOGGER.debug("registry entry found for: {}", (Object)potentialResourcePath);
            } else {
                LOGGER.debug("no registry entry found for: {}", (Object)potentialResourcePath);
            }
            if (pathElements.isEmpty() || pathElements.peek().equals(RELATIONSHIP_MARK)) {
                return matchedEntry;
            }
            String pathElement = pathElements.peek();
            if (potentialResourcePath.length() > 0) {
                potentialResourcePath.append(SEPARATOR);
            }
            potentialResourcePath.append(pathElement);
            if (matchedEntry != null && this.getEntryByPath(potentialResourcePath.toString()) == null) {
                return matchedEntry;
            }
            pathElements.poll();
        }
    }

    private RegistryEntry getEntryByPath(String path) {
        ResourceRepositoryInformation repositoryInformation;
        RegistryEntry entry = this.resourceRegistry.getEntryByPath(path);
        if (!(entry == null || (repositoryInformation = entry.getRepositoryInformation()) != null && repositoryInformation.isExposed())) {
            return null;
        }
        return entry;
    }
}

