/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceInformation;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.RelationshipsPath;
import io.crnk.core.engine.internal.repository.RelationshipRepositoryAdapter;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.exception.RequestBodyException;
import io.crnk.core.repository.response.JsonApiResponse;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;

public abstract class RelationshipsResourceUpsert
extends ResourceIncludeField {
    protected abstract HttpMethod method();

    protected abstract Result processToManyRelationship(Result<Object> var1, ResourceInformation var2, ResourceField var3, Collection<ResourceIdentifier> var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    protected abstract Result processToOneRelationship(Result<Object> var1, ResourceInformation var2, ResourceField var3, ResourceIdentifier var4, QueryAdapter var5, RelationshipRepositoryAdapter var6);

    @Override
    public final boolean isAcceptable(JsonPath jsonPath, String method) {
        return !jsonPath.isCollection() && RelationshipsPath.class.equals(jsonPath.getClass()) && this.method().name().equals(method);
    }

    @Override
    public final Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestBody) {
        Result result;
        RelationshipsPath relationshipsPath = (RelationshipsPath)jsonPath;
        RegistryEntry registryEntry = relationshipsPath.getRootEntry();
        this.logger.debug("using registry entry {}", (Object)registryEntry);
        HttpMethod method = this.method();
        QueryContext queryContext = queryAdapter.getQueryContext();
        String resourceType = registryEntry.getResourceInformation().getResourceType();
        this.assertRequestDocument(requestBody, method, resourceType);
        Serializable resourceId = jsonPath.getId();
        ResourceField relationshipField = relationshipsPath.getRelationship();
        ResourceFilterDirectory filterDirectory = this.context.getResourceFilterDirectory();
        boolean canAccess = filterDirectory.canAccess(relationshipField, method, queryContext, false);
        PreconditionUtil.verify(canAccess, "should be able to access or have an exception earlier, ignoring does not make sense here", new Object[0]);
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository();
        ResourceInformation targetInformation = this.getRegistryEntry(relationshipField.getOppositeResourceType()).getResourceInformation();
        RelationshipRepositoryAdapter relationshipRepositoryForClass = registryEntry.getRelationshipRepository(relationshipField);
        Result<Object> resource = resourceRepository.findOne(resourceId, queryAdapter).map(JsonApiResponse::getEntity);
        if (Collection.class.isAssignableFrom(relationshipField.getType())) {
            Collection dataBodies = requestBody.isMultiple() ? requestBody.getData().get() : Collections.singletonList(requestBody.getData().get());
            result = this.processToManyRelationship(resource, targetInformation, relationshipField, dataBodies, queryAdapter, relationshipRepositoryForClass);
        } else {
            if (requestBody.isMultiple()) {
                throw new RequestBodyException(method, resourceType, "Multiple data in body");
            }
            ResourceIdentifier dataBody = (ResourceIdentifier)requestBody.getData().get();
            result = this.processToOneRelationship(resource, targetInformation, relationshipField, dataBody, queryAdapter, relationshipRepositoryForClass);
        }
        Document document = null;
        int status = this.getStatus(document, method);
        return result.map(it -> new Response(document, status));
    }
}

