/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.internal.dispatcher.controller;

import io.crnk.core.engine.dispatcher.Response;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.http.HttpMethod;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceIncludeField;
import io.crnk.core.engine.internal.dispatcher.path.JsonPath;
import io.crnk.core.engine.internal.dispatcher.path.ResourcePath;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.document.mapper.DocumentMappingConfig;
import io.crnk.core.engine.internal.repository.ResourceRepositoryAdapter;
import io.crnk.core.engine.query.QueryAdapter;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.result.Result;
import io.crnk.core.repository.response.JsonApiResponse;
import io.crnk.core.utils.Nullable;
import java.io.Serializable;
import java.util.Collection;

public class CollectionGetController
extends ResourceIncludeField {
    @Override
    public boolean isAcceptable(JsonPath jsonPath, String method) {
        return jsonPath.isCollection() && jsonPath instanceof ResourcePath && HttpMethod.GET.name().equals(method);
    }

    @Override
    public Result<Response> handleAsync(JsonPath jsonPath, QueryAdapter queryAdapter, Document requestBody) {
        Result<JsonApiResponse> response;
        RegistryEntry registryEntry = jsonPath.getRootEntry();
        DocumentMappingConfig mappingConfig = this.context.getMappingConfig();
        DocumentMapper documentMapper = this.context.getDocumentMapper();
        ResourceRepositoryAdapter resourceRepository = registryEntry.getResourceRepository();
        if (jsonPath.getIds() == null || jsonPath.getIds().isEmpty()) {
            this.logger.debug("finding {}", (Object)queryAdapter);
            response = resourceRepository.findAll(queryAdapter);
        } else {
            Collection<Serializable> parsedIds = jsonPath.getIds();
            this.logger.debug("finding {} with ids {}", (Object)queryAdapter, parsedIds);
            response = resourceRepository.findAll(parsedIds, queryAdapter);
        }
        return response.merge(it -> documentMapper.toDocument((JsonApiResponse)it, queryAdapter, mappingConfig)).map(this::toResponse);
    }

    public Response toResponse(Document document) {
        if (!document.getData().isPresent()) {
            document.setData(Nullable.nullValue());
        }
        this.logger.debug("mapping {} to response");
        int status = this.getStatus(document, HttpMethod.GET);
        return new Response(document, status);
    }
}

