/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.information.resource;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import io.crnk.core.engine.document.Document;
import io.crnk.core.engine.document.Resource;
import io.crnk.core.engine.document.ResourceIdentifier;
import io.crnk.core.engine.information.bean.BeanAttributeInformation;
import io.crnk.core.engine.information.bean.BeanInformation;
import io.crnk.core.engine.information.resource.AnyResourceFieldAccessor;
import io.crnk.core.engine.information.resource.BeanInformationBase;
import io.crnk.core.engine.information.resource.ResourceField;
import io.crnk.core.engine.information.resource.ResourceFieldAccess;
import io.crnk.core.engine.information.resource.ResourceFieldAccessor;
import io.crnk.core.engine.information.resource.ResourceFieldType;
import io.crnk.core.engine.information.resource.ResourceInstanceBuilder;
import io.crnk.core.engine.information.resource.ResourceValidator;
import io.crnk.core.engine.information.resource.VersionRange;
import io.crnk.core.engine.internal.information.resource.DefaultResourceInstanceBuilder;
import io.crnk.core.engine.internal.information.resource.ResourceFieldImpl;
import io.crnk.core.engine.internal.utils.ClassUtils;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.parser.StringMapper;
import io.crnk.core.engine.parser.TypeParser;
import io.crnk.core.exception.InvalidResourceException;
import io.crnk.core.exception.ResourceDuplicateIdException;
import io.crnk.core.exception.ResourceException;
import io.crnk.core.queryspec.pagingspec.PagingSpec;
import io.crnk.core.resource.annotations.JsonApiId;
import io.crnk.core.resource.annotations.JsonApiRelationId;
import io.crnk.core.resource.annotations.JsonApiResource;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceInformation
extends BeanInformationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceInformation.class);
    private ResourceField parentField;
    private ResourceField idField;
    private List<ResourceField> relationshipFields;
    private ResourceField metaField;
    private ResourceField linksField;
    private final String resourceType;
    private String resourcePath;
    private ResourceInstanceBuilder<?> instanceBuilder;
    private final TypeParser parser;
    private String superResourceType;
    private AnyResourceFieldAccessor anyFieldAccessor;
    private ResourceValidator validator;
    private Class<? extends PagingSpec> pagingSpecType;
    private ResourceFieldAccess access = new ResourceFieldAccess(true, true, true, true, true, true);
    private StringMapper idStringMapper = new StringMapper(){

        public String toString(Object input) {
            return ResourceInformation.this.parser.toString(input);
        }

        @Override
        public Object parse(String input) {
            Class<?> idType = ResourceInformation.this.getIdField().getType();
            return ResourceInformation.this.parser.parse(input, idType);
        }
    };
    private ResourceFieldAccessor childIdAccessor;
    private ResourceFieldAccessor parentIdAccessor;
    private boolean singularNesting;
    private VersionRange versionRange = VersionRange.UNBOUNDED;

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String superResourceType, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, null, superResourceType, null, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String resourcePath, String superResourceType, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, resourcePath, superResourceType, null, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        this(parser, implementationType, resourceType, null, superResourceType, instanceBuilder, fields, pagingSpecType);
    }

    public ResourceInformation(TypeParser parser, Type implementationType, String resourceType, String resourcePath, String superResourceType, ResourceInstanceBuilder<?> instanceBuilder, List<ResourceField> fields, Class<? extends PagingSpec> pagingSpecType) {
        super(implementationType, fields);
        this.parser = parser;
        this.resourceType = resourceType;
        this.resourcePath = resourcePath;
        this.superResourceType = superResourceType;
        this.instanceBuilder = instanceBuilder;
        this.pagingSpecType = pagingSpecType;
        this.initFields();
        if (this.instanceBuilder == null) {
            this.instanceBuilder = new DefaultResourceInstanceBuilder(this.implementationClass);
        }
        this.initAny();
    }

    public ResourceFieldAccess getAccess() {
        return this.access;
    }

    public void setAccess(ResourceFieldAccess access) {
        this.access = access;
    }

    private boolean shouldBeNested() {
        JsonApiResource annotation = this.implementationClass.getAnnotation(JsonApiResource.class);
        return annotation != null && annotation.nested();
    }

    private void setupOneNesting() {
        String idName = this.idField.getUnderlyingName();
        for (ResourceField relationshipField : this.relationshipFields) {
            if (!relationshipField.hasIdField() || !idName.equals(relationshipField.getIdName())) continue;
            this.parentField = relationshipField;
            break;
        }
        PreconditionUtil.verify(this.parentField != null, "resource {} is marked as nested but no parent relationship found", new Object[0]);
        this.parentIdAccessor = this.childIdAccessor = new ResourceFieldAccessor(){

            @Override
            public Object getValue(Object object) {
                if (ResourceInformation.this.idField.getType().isInstance(object)) {
                    return object;
                }
                return ResourceInformation.this.idField.getAccessor().getValue(object);
            }

            @Override
            public void setValue(Object resource, Object fieldValue) {
                if (ResourceInformation.this.idField.getType().isInstance(resource)) {
                    throw new UnsupportedOperationException();
                }
                ResourceInformation.this.idField.getAccessor().getValue(fieldValue);
            }

            @Override
            public Class getImplementationClass() {
                return ResourceInformation.this.idField.getType();
            }
        };
        this.singularNesting = true;
    }

    private boolean setupManyNesting() {
        BeanAttributeInformation parentAttribute = null;
        BeanAttributeInformation idAttribute = null;
        BeanInformation beanInformation = BeanInformation.get(this.idField.getType());
        for (String attributeName : beanInformation.getAttributeNames()) {
            BeanAttributeInformation attribute = beanInformation.getAttribute(attributeName);
            if (attribute.getAnnotation(JsonApiRelationId.class).isPresent()) {
                PreconditionUtil.verify(parentAttribute == null, "nested identifiers can only have a single @JsonApiRelationId annotated field, got multiple for %s", beanInformation.getImplementationClass());
                parentAttribute = attribute;
                continue;
            }
            if (!attribute.getAnnotation(JsonApiId.class).isPresent()) continue;
            PreconditionUtil.verify(idAttribute == null, "nested identifiers can only one attribute being annotated with @JsonApiId, got multiple for %s", beanInformation.getImplementationClass());
            idAttribute = attribute;
        }
        if (parentAttribute != null || idAttribute != null) {
            if (!this.shouldBeNested()) {
                LOGGER.warn("add @JsonApiResource(nested=true) to {} to mark it as being nested, in the future automatic discovery based on the id will be removed", (Object)this.implementationClass);
            }
            PreconditionUtil.verify(idAttribute != null, "nested identifiers must have attribute annotated with @JsonApiId, got none for %s", beanInformation.getImplementationClass());
            PreconditionUtil.verify(parentAttribute != null, "nested identifiers must have attribute annotated with @JsonApiRelationId, got none for %s", beanInformation.getImplementationClass());
            String relationshipName = parentAttribute.getName().substring(0, parentAttribute.getName().length() - 2);
            this.parentIdAccessor = new NestedIdAccessor(parentAttribute);
            this.childIdAccessor = new NestedIdAccessor(idAttribute);
            String parentName = parentAttribute.getName();
            Optional<ResourceField> optParentField = this.relationshipFields.stream().filter(it -> it.hasIdField() && it.getIdName().equals(parentName)).findFirst();
            if (optParentField.isPresent()) {
                this.parentField = optParentField.get();
            } else {
                PreconditionUtil.verify(parentAttribute.getName().endsWith("Id"), "nested identifier must have @JsonApiRelationId field being named with a 'Id' suffix or match in name with a @JsonApiRelationId annotated field on the resource, got %s for %s", parentAttribute.getName(), beanInformation.getImplementationClass());
                this.parentField = this.findFieldByUnderlyingName(relationshipName);
                PreconditionUtil.verify(this.parentField != null, "naming of relationship to parent resource and relationship identifier within resource identifier must match, not found for %s of %s", parentAttribute.getName(), this.implementationClass);
                ((ResourceFieldImpl)this.parentField).setIdField(parentAttribute.getName(), parentAttribute.getImplementationClass(), this.parentIdAccessor);
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public void initNesting() {
        boolean nested = this.setupManyNesting();
        if (!nested && this.shouldBeNested()) {
            this.setupOneNesting();
        }
        if (this.isNested()) {
            PreconditionUtil.verify(this.parentField.getOppositeName() != null, "relationship between parent pointing to a nested resource must specify @JsonApiRelation.mappedBy or @JsonApiRelation.opposite, not found for '%s' of %s", this.parentField.getUnderlyingName(), this.implementationClass);
        }
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Deprecated
    public void setValidator(ResourceValidator validator) {
        this.validator = validator;
    }

    @Deprecated
    public ResourceValidator getValidator() {
        return this.validator;
    }

    @Deprecated
    public void setIdStringMapper(StringMapper idStringMapper) {
        this.idStringMapper = idStringMapper;
    }

    public StringMapper getIdStringMapper() {
        return this.idStringMapper;
    }

    public AnyResourceFieldAccessor getAnyFieldAccessor() {
        return this.anyFieldAccessor;
    }

    private void initAny() {
        Method jsonAnySetter;
        final Method jsonAnyGetter = ClassUtils.findMethodWith(this.implementationClass, JsonAnyGetter.class);
        if (ResourceInformation.absentAnySetter(jsonAnyGetter, jsonAnySetter = ClassUtils.findMethodWith(this.implementationClass, JsonAnySetter.class))) {
            throw new InvalidResourceException(String.format("A resource %s has to have both methods annotated with @JsonAnySetter and @JsonAnyGetter", this.implementationClass.getCanonicalName()));
        }
        if (jsonAnyGetter != null) {
            this.anyFieldAccessor = new AnyResourceFieldAccessor(){

                @Override
                public Map<String, Object> getValues(Object resource) {
                    try {
                        Object o = jsonAnyGetter.invoke(resource, new Object[0]);
                        return (Map)o;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ResourceException(String.format("Exception while reading %s due to %s", resource, e.getMessage()), e);
                    }
                }

                @Override
                public void setValue(Object resource, String name, Object fieldValue) {
                    try {
                        jsonAnySetter.invoke(resource, name, fieldValue);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new ResourceException(String.format("Exception while writting %s.%s=%s due to %s", resource, name, fieldValue, e.getMessage()), e);
                    }
                }
            };
        }
    }

    private static boolean absentAnySetter(Method jsonAnyGetter, Method jsonAnySetter) {
        return jsonAnySetter == null && jsonAnyGetter != null || jsonAnySetter != null && jsonAnyGetter == null;
    }

    @Override
    protected void initFields() {
        super.initFields();
        if (this.fields != null) {
            List<ResourceField> idFields = ResourceFieldType.ID.filter(this.fields);
            if (idFields.size() > 1) {
                throw new ResourceDuplicateIdException(this.implementationClass.getCanonicalName());
            }
            this.idField = idFields.isEmpty() ? null : idFields.get(0);
            this.relationshipFields = ResourceFieldType.RELATIONSHIP.filter(this.fields);
            this.metaField = ResourceInformation.getField(this.implementationClass, ResourceFieldType.META_INFORMATION, this.fields);
            this.linksField = ResourceInformation.getField(this.implementationClass, ResourceFieldType.LINKS_INFORMATION, this.fields);
        } else {
            this.relationshipFields = Collections.emptyList();
            this.metaField = null;
            this.linksField = null;
            this.idField = null;
        }
    }

    @Override
    protected void initField(ResourceField resourceField) {
        resourceField.setResourceInformation(this);
        super.initField(resourceField);
    }

    private static <T> ResourceField getField(Class<T> resourceClass, ResourceFieldType type, Collection<ResourceField> classFields) {
        ArrayList<ResourceField> matches = new ArrayList<ResourceField>(1);
        for (ResourceField field : classFields) {
            if (field.getResourceFieldType() != type) continue;
            matches.add(field);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("multiple " + (Object)((Object)type) + " fields for + " + resourceClass.getCanonicalName());
        }
        return (ResourceField)matches.get(0);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getResourcePath() {
        if (this.resourcePath == null) {
            return this.resourceType;
        }
        return this.resourcePath;
    }

    public String getSuperResourceType() {
        return this.superResourceType;
    }

    public <T> ResourceInstanceBuilder<T> getInstanceBuilder() {
        return this.instanceBuilder;
    }

    public Class<?> getResourceClass() {
        return this.getImplementationClass();
    }

    public ResourceField getIdField() {
        return this.idField;
    }

    public List<ResourceField> getRelationshipFields() {
        return this.relationshipFields;
    }

    @Deprecated
    public ResourceField findRelationshipFieldByName(String name) {
        ResourceField resourceField = this.findFieldByName(name);
        return resourceField != null && resourceField.getResourceFieldType() == ResourceFieldType.RELATIONSHIP ? resourceField : null;
    }

    public ResourceField getMetaField() {
        return this.metaField;
    }

    public ResourceField getLinksField() {
        return this.linksField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInformation that = (ResourceInformation)o;
        return Objects.equals(this.implementationClass, that.implementationClass) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.resourcePath, that.resourcePath);
    }

    public int hashCode() {
        return Objects.hash(this.resourceType);
    }

    public String toIdString(Object id) {
        if (id == null) {
            return null;
        }
        return this.idStringMapper.toString(id);
    }

    public ResourceIdentifier toResourceIdentifier(Object resourceOrId) {
        if (resourceOrId == null) {
            return null;
        }
        if (resourceOrId instanceof Resource) {
            return ((Resource)resourceOrId).toIdentifier();
        }
        if (this.implementationClass.isInstance(resourceOrId)) {
            resourceOrId = this.getId(resourceOrId);
        }
        if (resourceOrId instanceof ResourceIdentifier) {
            return (ResourceIdentifier)resourceOrId;
        }
        String strId = resourceOrId instanceof String ? (String)resourceOrId : this.toIdString(resourceOrId);
        return new ResourceIdentifier(strId, this.getResourceType());
    }

    public Serializable parseIdString(String id) {
        if (id == null) {
            return null;
        }
        return (Serializable)this.idStringMapper.parse(id);
    }

    public Object getId(Object resource) {
        return this.idField.getAccessor().getValue(resource);
    }

    public void setId(Object resource, Object id) {
        this.idField.getAccessor().setValue(resource, id);
    }

    public void verify(Object resource, Document requestDocument) {
        if (this.validator != null) {
            this.validator.validate(resource, requestDocument);
        }
    }

    public Class<? extends PagingSpec> getPagingSpecType() {
        return this.pagingSpecType;
    }

    public boolean isNested() {
        return this.parentField != null;
    }

    public boolean isSingularNesting() {
        PreconditionUtil.verify(this.isNested(), "not a nested resource", new Object[0]);
        return this.singularNesting;
    }

    public ResourceField getParentField() {
        PreconditionUtil.verify(this.parentField != null, "not a nested resource, cannot access parent field", new Object[0]);
        return this.parentField;
    }

    public ResourceFieldAccessor getChildIdAccessor() {
        PreconditionUtil.verify(this.isNested(), "not a nested resource, cannot access nested id accessor", new Object[0]);
        return this.childIdAccessor;
    }

    public ResourceFieldAccessor getParentIdAccessor() {
        PreconditionUtil.verify(this.isNested(), "not a nested resource, cannot access nested id accessor", new Object[0]);
        return this.parentIdAccessor;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public void setVersionRange(VersionRange versionRange) {
        this.versionRange = versionRange;
    }

    class NestedIdAccessor
    implements ResourceFieldAccessor {
        private final BeanAttributeInformation nestedField;

        protected NestedIdAccessor(BeanAttributeInformation nestedField) {
            this.nestedField = nestedField;
        }

        @Override
        public Object getValue(Object object) {
            if (ResourceInformation.this.idField.getType().isInstance(object)) {
                return this.nestedField.getValue(object);
            }
            Object id = ResourceInformation.this.getIdField().getAccessor().getValue(object);
            return this.nestedField.getValue(id);
        }

        @Override
        public void setValue(Object object, Object fieldValue) {
            if (ResourceInformation.this.idField.getType().isInstance(object)) {
                this.nestedField.setValue(object, fieldValue);
            } else {
                Object id = ResourceInformation.this.getIdField().getAccessor().getValue(object);
                this.nestedField.setValue(id, fieldValue);
            }
        }

        @Override
        public Class getImplementationClass() {
            return this.nestedField.getImplementationClass();
        }
    }
}

