/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.http;

import io.crnk.core.engine.http.HttpStatus;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse {
    private Map<String, String> headers = new HashMap<String, String>();
    private int statusCode;
    private byte[] body;
    private String statusMessage;

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            return HttpStatus.toMessage(this.statusCode);
        }
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setBody(String body) {
        this.body = body.getBytes(Charset.forName("utf8"));
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setContentType(String contentType) {
        this.setHeader("Content-Type", contentType);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[status=" + this.statusCode + ",bodyLength=" + (this.body != null ? this.body.length : 0) + ",headers=" + this.headers + "]";
    }
}

