/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.http;

import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.core.engine.query.QueryContext;
import io.crnk.core.engine.result.Result;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.utils.Supplier;

public class HttpRequestContextProvider {
    private final ModuleRegistry moduleRegistry;
    private Supplier<ResultFactory> resultFactory;
    private ServiceUrlProvider serviceUrlProvider = new ServiceUrlProvider(){

        @Override
        public String getUrl() {
            HttpRequestContext request = HttpRequestContextProvider.this.getRequestContext();
            if (request == null) {
                return null;
            }
            return request.getBaseUrl();
        }
    };

    public HttpRequestContextProvider(Supplier<ResultFactory> resultFactory, ModuleRegistry moduleRegistry) {
        this.resultFactory = resultFactory;
        this.moduleRegistry = moduleRegistry;
    }

    public HttpRequestContext getRequestContext() {
        return (HttpRequestContext)this.resultFactory.get().getThreadContext();
    }

    public Result<HttpRequestContext> getRequestContextResult() {
        return this.resultFactory.get().getContext();
    }

    public void onRequestStarted(HttpRequestContext request) {
        this.resultFactory.get().setThreadContext(request);
        QueryContext queryContext = request.getQueryContext();
        queryContext.initializeDefaults(this.moduleRegistry.getResourceRegistry());
    }

    public boolean hasThreadRequestContext() {
        return this.resultFactory.get().hasThreadContext();
    }

    public void onRequestFinished() {
        this.resultFactory.get().clearContext();
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    public <T> Result<T> attach(Result<T> result) {
        HttpRequestContext requestContext = this.getRequestContext();
        return this.resultFactory.get().attachContext(result, requestContext);
    }
}

