/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.engine.document;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import java.util.Objects;

public class ResourceIdentifier
implements Comparable<ResourceIdentifier> {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected String id;
    protected String type;

    public ResourceIdentifier() {
    }

    public ResourceIdentifier(String id, String type) {
        PreconditionUtil.verify(type != null, "type cannot be null", new Object[0]);
        PreconditionUtil.verify(id == null || !id.startsWith("ResourceIdentifier{id="), "cannot pass ResourceIdentifier as id", new Object[0]);
        this.id = id;
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ResourceIdentifier other = (ResourceIdentifier)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.type, other.type);
    }

    @Override
    public int compareTo(ResourceIdentifier o) {
        int d = this.type.compareTo(o.type);
        if (d != 0) {
            return d;
        }
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id='" + this.id + '\'' + ", type='" + this.type + '\'' + '}';
    }

    public ResourceIdentifier toIdentifier() {
        return this;
    }
}

