/*
 * Decompiled with CFR 0.152.
 */
package io.crnk.core.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.crnk.core.engine.error.ExceptionMapper;
import io.crnk.core.engine.filter.DocumentFilter;
import io.crnk.core.engine.filter.ResourceFilter;
import io.crnk.core.engine.filter.ResourceFilterDirectory;
import io.crnk.core.engine.filter.ResourceModificationFilter;
import io.crnk.core.engine.http.HttpRequestContextAware;
import io.crnk.core.engine.http.HttpStatusBehavior;
import io.crnk.core.engine.information.contributor.ResourceFieldContributor;
import io.crnk.core.engine.information.resource.ResourceInformationProviderModule;
import io.crnk.core.engine.internal.CoreModule;
import io.crnk.core.engine.internal.dispatcher.ControllerRegistry;
import io.crnk.core.engine.internal.dispatcher.controller.CollectionGetController;
import io.crnk.core.engine.internal.dispatcher.controller.Controller;
import io.crnk.core.engine.internal.dispatcher.controller.ControllerContext;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourceGetController;
import io.crnk.core.engine.internal.dispatcher.controller.FieldResourcePost;
import io.crnk.core.engine.internal.dispatcher.controller.RelationsDeleteController;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsPatchController;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsPostController;
import io.crnk.core.engine.internal.dispatcher.controller.RelationshipsResourceGetController;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceDeleteController;
import io.crnk.core.engine.internal.dispatcher.controller.ResourceGetController;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePatchController;
import io.crnk.core.engine.internal.dispatcher.controller.ResourcePostController;
import io.crnk.core.engine.internal.document.mapper.DocumentMapper;
import io.crnk.core.engine.internal.exception.ExceptionMapperRegistry;
import io.crnk.core.engine.internal.http.HttpRequestDispatcherImpl;
import io.crnk.core.engine.internal.http.JsonApiRequestProcessor;
import io.crnk.core.engine.internal.jackson.JacksonModule;
import io.crnk.core.engine.internal.registry.ResourceRegistryImpl;
import io.crnk.core.engine.internal.utils.PreconditionUtil;
import io.crnk.core.engine.properties.NullPropertiesProvider;
import io.crnk.core.engine.properties.PropertiesProvider;
import io.crnk.core.engine.query.QueryAdapterBuilder;
import io.crnk.core.engine.registry.DefaultResourceRegistryPart;
import io.crnk.core.engine.registry.HierarchicalResourceRegistryPart;
import io.crnk.core.engine.registry.RegistryEntry;
import io.crnk.core.engine.registry.ResourceRegistry;
import io.crnk.core.engine.registry.ResourceRegistryPart;
import io.crnk.core.engine.registry.ResourceRegistryPartBase;
import io.crnk.core.engine.result.ResultFactory;
import io.crnk.core.engine.security.SecurityProvider;
import io.crnk.core.engine.url.ConstantServiceUrlProvider;
import io.crnk.core.engine.url.ServiceUrlProvider;
import io.crnk.core.module.Module;
import io.crnk.core.module.ModuleRegistry;
import io.crnk.core.module.SimpleModule;
import io.crnk.core.module.discovery.DefaultServiceDiscoveryFactory;
import io.crnk.core.module.discovery.EmptyServiceDiscovery;
import io.crnk.core.module.discovery.ServiceDiscovery;
import io.crnk.core.module.discovery.ServiceDiscoveryFactory;
import io.crnk.core.queryspec.internal.QuerySpecAdapterBuilder;
import io.crnk.core.queryspec.mapper.DefaultQuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.QuerySpecUrlMapper;
import io.crnk.core.queryspec.mapper.UnkonwnMappingAware;
import io.crnk.core.queryspec.pagingspec.LimitBoundedPagingBehavior;
import io.crnk.core.queryspec.pagingspec.OffsetLimitPagingBehavior;
import io.crnk.core.queryspec.pagingspec.PagingBehavior;
import io.crnk.core.repository.Repository;
import io.crnk.core.repository.decorate.RepositoryDecoratorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrnkBoot {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrnkBoot.class);
    private static final String DISCOVERY_MODULE_NAME = "discovery";
    private final ModuleRegistry moduleRegistry = new ModuleRegistry();
    private ObjectMapper objectMapper;
    private boolean configured;
    private ResourceRegistry resourceRegistry;
    private HttpRequestDispatcherImpl requestDispatcher;
    private PropertiesProvider propertiesProvider = new NullPropertiesProvider();
    private ServiceDiscoveryFactory serviceDiscoveryFactory = new DefaultServiceDiscoveryFactory();
    private ServiceDiscovery serviceDiscovery = null;
    private DocumentMapper documentMapper;
    private List<Module> registeredModules = new ArrayList<Module>();
    private Long defaultPageLimit = null;
    private Long maxPageLimit = null;
    private Boolean allowUnknownAttributes;
    private Boolean allowUnknownParameters;
    private QueryAdapterBuilder queryAdapterBuilder;
    private CoreModule coreModule = new CoreModule();
    private Map<String, String> serverInfo = new HashMap<String, String>();
    private String webPathPrefix;
    private ControllerRegistry controllerRegistry;

    private static String buildServiceUrl(String resourceDefaultDomain, String webPathPrefix) {
        return resourceDefaultDomain + (webPathPrefix != null ? webPathPrefix : "");
    }

    public void putServerInfo(String key, String value) {
        this.serverInfo.put(key, value);
        this.moduleRegistry.setServerInfo(this.serverInfo);
    }

    public void setServiceDiscoveryFactory(ServiceDiscoveryFactory factory) {
        this.checkNotConfiguredYet();
        PreconditionUtil.verify(this.serviceDiscovery == null, "serviceDiscovery already initialized: %s", this.serviceDiscovery);
        this.serviceDiscoveryFactory = factory;
    }

    public void addModule(Module module) {
        this.checkNotConfiguredYet();
        this.setupInstance(module);
        this.registeredModules.add(module);
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.checkNotConfiguredYet();
        this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(serviceUrlProvider);
    }

    private void checkNotConfiguredYet() {
        if (this.configured) {
            throw new IllegalStateException("cannot further modify CrnkBoot once configured/initialized");
        }
    }

    public void boot() {
        LOGGER.debug("performing setup");
        this.checkNotConfiguredYet();
        this.configured = true;
        this.moduleRegistry.setPropertiesProvider(this.propertiesProvider);
        this.setupServiceUrlProvider();
        this.setupServiceDiscovery();
        this.setupQuerySpecUrlMapper();
        this.bootDiscovery();
        LOGGER.debug("completed setup");
    }

    private void bootDiscovery() {
        this.setupObjectMapper();
        this.resourceRegistry = new ResourceRegistryImpl(null, this.moduleRegistry);
        this.addModules();
        this.setupPagingBehavior();
        this.setupComponents();
        ResourceRegistryPart rootPart = this.setupResourceRegistry();
        this.moduleRegistry.init(this.objectMapper);
        this.setupRepositories(rootPart);
        this.requestDispatcher = this.createRequestDispatcher(this.moduleRegistry.getExceptionMapperRegistry());
        this.moduleRegistry.setDocumentMapper(this.documentMapper);
        this.logInfo();
    }

    private void setupServiceDiscovery() {
        if (this.serviceDiscovery == null) {
            if (this.serviceDiscoveryFactory != null) {
                this.setServiceDiscovery(this.serviceDiscoveryFactory.getInstance());
            } else {
                this.setServiceDiscovery(new EmptyServiceDiscovery());
            }
        }
    }

    private void logInfo() {
        int numResources = this.resourceRegistry.getEntries().size();
        List modules = this.moduleRegistry.getModules().stream().map(Module::getModuleName).collect(Collectors.toList());
        modules.remove("resourceInformationProviderModule");
        modules.remove(DISCOVERY_MODULE_NAME);
        modules.remove("core");
        List<String> securityProviders = this.toSimpleNames(this.moduleRegistry.getSecurityProviders());
        List<String> pagingBehaviors = this.toSimpleNames(this.moduleRegistry.getPagingBehaviors());
        QuerySpecUrlMapper urlMapper = this.moduleRegistry.getUrlMapper();
        ServiceDiscovery serviceDiscovery = this.moduleRegistry.getServiceDiscovery();
        LOGGER.info("crnk initialized: numResources={}, usedModules={}, securityProviders={}, pagingBehaviors={}, urlMapper={}, serviceDiscovery={}", new Object[]{numResources, modules, securityProviders, pagingBehaviors, urlMapper.getClass().getSimpleName(), serviceDiscovery.getClass().getSimpleName()});
    }

    private List<String> toSimpleNames(List<?> implementations) {
        return implementations.stream().map(it -> it.getClass().getSimpleName()).collect(Collectors.toList());
    }

    private void setupRepositories(ResourceRegistryPart rootPart) {
        for (RegistryEntry entry : this.moduleRegistry.getRegistryEntries()) {
            rootPart.addEntry(entry);
        }
    }

    private ResourceRegistryPart setupResourceRegistry() {
        ResourceRegistryPartBase rootPart;
        Map<String, ResourceRegistryPart> registryParts = this.moduleRegistry.getRegistryParts();
        if (registryParts.isEmpty()) {
            rootPart = new DefaultResourceRegistryPart();
        } else {
            HierarchicalResourceRegistryPart hierarchialPart = new HierarchicalResourceRegistryPart();
            for (Map.Entry<String, ResourceRegistryPart> entry : registryParts.entrySet()) {
                hierarchialPart.putPart(entry.getKey(), entry.getValue());
            }
            if (!registryParts.containsKey("")) {
                DefaultResourceRegistryPart defaultResourceRegistryPart = new DefaultResourceRegistryPart();
                hierarchialPart.putPart("", defaultResourceRegistryPart);
                this.moduleRegistry.getContext().addRegistryPart("", defaultResourceRegistryPart);
            }
            rootPart = hierarchialPart;
        }
        ((ResourceRegistryImpl)this.resourceRegistry).setRootPart(rootPart);
        return rootPart;
    }

    private void setupObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.findAndRegisterModules();
            this.objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.moduleRegistry.setObjectMapper(this.objectMapper);
    }

    public ExceptionMapperRegistry getExceptionMapperRegistry() {
        return this.moduleRegistry.getExceptionMapperRegistry();
    }

    private HttpRequestDispatcherImpl createRequestDispatcher(ExceptionMapperRegistry exceptionMapperRegistry) {
        this.documentMapper = this.createDocumentMapper();
        return new HttpRequestDispatcherImpl(this.moduleRegistry, exceptionMapperRegistry);
    }

    protected QueryAdapterBuilder createQueryAdapterBuilder() {
        return new QuerySpecAdapterBuilder(this.moduleRegistry.getUrlMapper(), this.moduleRegistry);
    }

    protected DocumentMapper createDocumentMapper() {
        ResourceFilterDirectory filterDirectory = this.moduleRegistry.getContext().getResourceFilterDirectory();
        ResultFactory resultFactory = this.moduleRegistry.getContext().getResultFactory();
        return new DocumentMapper(this.resourceRegistry, this.objectMapper, this.propertiesProvider, filterDirectory, resultFactory, this.serverInfo, this.moduleRegistry.getUrlBuilder());
    }

    protected ControllerRegistry createControllerRegistry() {
        HashSet<Controller> controllers = new HashSet<Controller>();
        controllers.add(new RelationsDeleteController());
        controllers.add(new RelationshipsPatchController());
        controllers.add(new RelationshipsPostController());
        controllers.add(new ResourceDeleteController());
        controllers.add(new CollectionGetController());
        controllers.add(new FieldResourceGetController());
        controllers.add(new RelationshipsResourceGetController());
        controllers.add(new ResourceGetController());
        controllers.add(new FieldResourcePost());
        controllers.add(new ResourcePatchController());
        controllers.add(new ResourcePostController());
        ControllerContext context = new ControllerContext(this.moduleRegistry, this::getDocumentMapper);
        for (Controller controller : controllers) {
            controller.init(context);
        }
        ControllerRegistry controllerRegistry = new ControllerRegistry(controllers);
        this.moduleRegistry.setControllerRegistry(controllerRegistry);
        return controllerRegistry;
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    private void setupComponents() {
        LOGGER.debug("performing service discovery with {}", (Object)this.serviceDiscovery);
        SimpleModule module = new SimpleModule(DISCOVERY_MODULE_NAME){

            @Override
            public void setupModule(Module.ModuleContext context) {
                CrnkBoot.this.controllerRegistry = CrnkBoot.this.createControllerRegistry();
                CrnkBoot.this.queryAdapterBuilder = CrnkBoot.this.createQueryAdapterBuilder();
                CrnkBoot.this.moduleRegistry.setQueryAdapterBuilder(CrnkBoot.this.queryAdapterBuilder);
                this.addHttpRequestProcessor(new JsonApiRequestProcessor(context));
                super.setupModule(context);
            }
        };
        for (ExceptionMapper exceptionMapper : this.getInstancesByType(ExceptionMapper.class)) {
            module.addExceptionMapper(exceptionMapper);
        }
        for (DocumentFilter documentFilter : this.getInstancesByType(DocumentFilter.class)) {
            module.addFilter(documentFilter);
        }
        List<Repository> repositories = this.getInstancesByType(Repository.class);
        for (Repository repository : repositories) {
            module.addRepository(repository);
        }
        List<ResourceFieldContributor> list = this.getInstancesByType(ResourceFieldContributor.class);
        for (ResourceFieldContributor resourceFieldContributor : list) {
            module.addResourceFieldContributor(resourceFieldContributor);
        }
        List<RepositoryDecoratorFactory> list2 = this.getInstancesByType(RepositoryDecoratorFactory.class);
        for (RepositoryDecoratorFactory repositoryDecoratorFactory : list2) {
            module.addRepositoryDecoratorFactory(repositoryDecoratorFactory);
        }
        List<ResourceModificationFilter> list3 = this.getInstancesByType(ResourceModificationFilter.class);
        for (ResourceModificationFilter resourceModificationFilter : list3) {
            module.addResourceModificationFilter(resourceModificationFilter);
        }
        List<ResourceFilter> list4 = this.getInstancesByType(ResourceFilter.class);
        for (ResourceFilter resourceFilter : list4) {
            module.addResourceFilter(resourceFilter);
        }
        List<HttpStatusBehavior> list5 = this.getInstancesByType(HttpStatusBehavior.class);
        for (HttpStatusBehavior httpStatusBehavior : list5) {
            module.addHttpStatusBehavior(httpStatusBehavior);
        }
        List<SecurityProvider> list6 = this.getInstancesByType(SecurityProvider.class);
        for (SecurityProvider securityProvider : list6) {
            module.addSecurityProvider(securityProvider);
        }
        this.moduleRegistry.addModule(module);
        this.moduleRegistry.addModule(new ResourceInformationProviderModule());
    }

    private <T> List<T> getInstancesByType(Class<T> clazz) {
        List<T> instancesByType = this.serviceDiscovery.getInstancesByType(clazz);
        for (T instance : instancesByType) {
            this.setupInstance(instance);
        }
        return instancesByType;
    }

    private <T> void setupInstance(T instance) {
        if (instance instanceof HttpRequestContextAware) {
            HttpRequestContextAware aware = (HttpRequestContextAware)instance;
            aware.setHttpRequestContextProvider(this.moduleRegistry.getHttpRequestContextProvider());
        }
    }

    private void addModules() {
        boolean serializeLinksAsObjects = Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.serialize.object.links"));
        this.moduleRegistry.addModule(new JacksonModule(this.objectMapper, serializeLinksAsObjects));
        this.moduleRegistry.addModule(this.coreModule);
        for (Module module : this.registeredModules) {
            this.moduleRegistry.addModule(module);
        }
        List<Module> discoveredModules = this.getInstancesByType(Module.class);
        for (Module module : discoveredModules) {
            this.moduleRegistry.addModule(module);
        }
    }

    private void setupServiceUrlProvider() {
        String resourceDefaultDomain = this.propertiesProvider.getProperty("crnk.config.core.resource.domain");
        String webPathPrefix = this.getWebPathPrefix();
        if (resourceDefaultDomain != null) {
            String serviceUrl = CrnkBoot.buildServiceUrl(resourceDefaultDomain, webPathPrefix);
            this.moduleRegistry.getHttpRequestContextProvider().setServiceUrlProvider(new ConstantServiceUrlProvider(serviceUrl));
        }
    }

    public HttpRequestDispatcherImpl getRequestDispatcher() {
        PreconditionUtil.verify(this.requestDispatcher != null, "requestDispatcher not yet available, initialize CrnkBoot first", new Object[0]);
        return this.requestDispatcher;
    }

    public ResourceRegistry getResourceRegistry() {
        PreconditionUtil.verify(this.resourceRegistry != null, "resourceRegistry not yet available, initialize CrnkBoot first", new Object[0]);
        return this.resourceRegistry;
    }

    public ObjectMapper getObjectMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.verify(this.objectMapper == null, "ObjectMapper already set", new Object[0]);
        this.objectMapper = objectMapper;
    }

    public PropertiesProvider getPropertiesProvider() {
        return this.propertiesProvider;
    }

    public void setPropertiesProvider(PropertiesProvider propertiesProvider) {
        this.checkNotConfiguredYet();
        LOGGER.debug("set properties provider {}", (Object)propertiesProvider);
        this.propertiesProvider = propertiesProvider;
    }

    public String getWebPathPrefix() {
        String pathPrefix = null;
        pathPrefix = this.webPathPrefix != null ? this.webPathPrefix : this.propertiesProvider.getProperty("crnk.config.web.path.prefix");
        if (pathPrefix != null && !pathPrefix.startsWith("/")) {
            pathPrefix = "/" + pathPrefix;
        }
        if (pathPrefix != null && pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
        }
        return pathPrefix;
    }

    public ServiceDiscovery getServiceDiscovery() {
        return this.moduleRegistry.getServiceDiscovery();
    }

    public void setServiceDiscovery(ServiceDiscovery serviceDiscovery) {
        LOGGER.debug("set service discovery {}", (Object)serviceDiscovery);
        PreconditionUtil.verify(this.serviceDiscovery == null, "serviceDiscovery already set: %s", this.serviceDiscovery);
        this.serviceDiscovery = serviceDiscovery;
        this.moduleRegistry.setServiceDiscovery(serviceDiscovery);
    }

    public void setDefaultPageLimit(Long defaultPageLimit) {
        this.defaultPageLimit = defaultPageLimit;
    }

    public void setMaxPageLimit(Long maxPageLimit) {
        this.maxPageLimit = maxPageLimit;
    }

    public void setAllowUnknownAttributes() {
        this.allowUnknownAttributes = true;
    }

    public void setAllowUnknownParameters() {
        this.allowUnknownParameters = true;
    }

    public ModuleRegistry getModuleRegistry() {
        return this.moduleRegistry;
    }

    private void setupQuerySpecUrlMapper() {
        QuerySpecUrlMapper urlMapper;
        if (this.moduleRegistry.getUrlMapper() == null) {
            List<QuerySpecUrlMapper> list = this.serviceDiscovery.getInstancesByType(QuerySpecUrlMapper.class);
            if (list.isEmpty()) {
                this.moduleRegistry.setUrlMapper(new DefaultQuerySpecUrlMapper());
            } else {
                this.moduleRegistry.setUrlMapper(list.get(0));
            }
        }
        if ((urlMapper = this.moduleRegistry.getUrlMapper()) instanceof UnkonwnMappingAware) {
            String strAllow;
            if (this.allowUnknownAttributes == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownAttributes")) != null) {
                this.allowUnknownAttributes = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownAttributes != null) {
                ((UnkonwnMappingAware)((Object)urlMapper)).setAllowUnknownAttributes(this.allowUnknownAttributes);
            }
            if (this.allowUnknownParameters == null && (strAllow = this.propertiesProvider.getProperty("crnk.config.resource.request.allowUnknownParameters")) != null) {
                this.allowUnknownParameters = Boolean.parseBoolean(strAllow);
            }
            if (this.allowUnknownParameters != null) {
                ((UnkonwnMappingAware)((Object)urlMapper)).setAllowUnknownParameters(this.allowUnknownParameters);
            }
        }
    }

    private void setupPagingBehavior() {
        this.moduleRegistry.addAllPagingBehaviors(this.serviceDiscovery.getInstancesByType(PagingBehavior.class));
        if (this.moduleRegistry.getPagingBehaviors().isEmpty()) {
            this.moduleRegistry.addPagingBehavior(new OffsetLimitPagingBehavior());
        }
        for (PagingBehavior pagingBehavior : this.moduleRegistry.getPagingBehaviors()) {
            if (!(pagingBehavior instanceof LimitBoundedPagingBehavior)) continue;
            if (this.defaultPageLimit != null) {
                ((LimitBoundedPagingBehavior)pagingBehavior).setDefaultLimit(this.defaultPageLimit);
            } else {
                LOGGER.warn("no defaultLimit for paging specified, may lead to denial of service for in proper requests with large data sets");
            }
            if (this.maxPageLimit == null) continue;
            ((LimitBoundedPagingBehavior)pagingBehavior).setMaxPageLimit(this.maxPageLimit);
        }
    }

    public void setUrlMapper(QuerySpecUrlMapper urlMapper) {
        this.checkNotConfiguredYet();
        PreconditionUtil.verify(urlMapper != null, "urlMapper parameter must not be null", new Object[0]);
        this.moduleRegistry.setUrlMapper(urlMapper);
    }

    public boolean isNullDataResponseEnabled() {
        return Boolean.parseBoolean(this.propertiesProvider.getProperty("crnk.config.null.data.response.enabled"));
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.moduleRegistry.getHttpRequestContextProvider().getServiceUrlProvider();
    }

    public List<PagingBehavior> getPagingBehaviors() {
        return this.moduleRegistry.getPagingBehaviors();
    }

    public ControllerRegistry getControllerRegistry() {
        return this.controllerRegistry;
    }

    public QueryAdapterBuilder getQueryAdapterBuilder() {
        return this.queryAdapterBuilder;
    }

    public CoreModule getCoreModule() {
        return this.coreModule;
    }

    public QuerySpecUrlMapper getUrlMapper() {
        this.setupQuerySpecUrlMapper();
        return this.moduleRegistry.getUrlMapper();
    }

    public void setWebPathPrefix(String webPathPrefix) {
        this.webPathPrefix = webPathPrefix;
    }
}

