/*
 * Decompiled with CFR 0.152.
 */
package io.continual.builder;

import io.continual.builder.BuilderDataSource;
import io.continual.builder.sources.BuilderJsonDataSource;
import io.continual.builder.sources.BuilderPrefsDataSource;
import io.continual.builder.sources.BuilderReadableDataSource;
import io.continual.builder.sources.BuilderStringDataSource;
import io.continual.util.nv.NvReadable;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import java.util.prefs.Preferences;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Builder<T> {
    private final Class<T> fBase;
    private String fClassName;
    private boolean fClassNameInData;
    private ClassLoader fClassLoader;
    private BuilderDataSource fData;
    private Object fContext;
    private Class<? extends Object> fContextClass;
    private boolean fRestrictSearchToPath = false;
    private LinkedList<String> fSearchPath;
    private static final Logger log = LoggerFactory.getLogger(Builder.class);

    private Builder(Class<T> base) {
        this.fBase = base;
        this.fClassName = null;
        this.fClassNameInData = true;
        this.fClassLoader = null;
        this.fData = null;
        this.fContext = null;
        this.fContextClass = null;
    }

    public static <T> T fromJson(Class<T> base, JSONObject data) throws BuildFailure {
        return Builder.withBaseClass(base).withClassNameInData().usingData(new BuilderJsonDataSource(data)).build();
    }

    public static <T> T fromJson(Class<T> base, JSONObject data, Object context) throws BuildFailure {
        return Builder.withBaseClass(base).withClassNameInData().usingData(new BuilderJsonDataSource(data)).providingContext(context).build();
    }

    public static <T> Builder<T> withBaseClass(Class<T> base) {
        return new Builder<T>(base);
    }

    public Builder<T> usingClassName(String classname) {
        this.fClassName = classname;
        this.fClassNameInData = false;
        return this;
    }

    public Builder<T> withClassNameInData() {
        this.fClassName = null;
        this.fClassNameInData = true;
        return this;
    }

    public Builder<T> usingClassLoader(ClassLoader loader) {
        this.fClassLoader = loader;
        return this;
    }

    public Builder<T> usingData(BuilderDataSource dataSource) {
        this.fData = dataSource;
        return this;
    }

    public Builder<T> fromString(String data) {
        return this.usingData(new BuilderStringDataSource(data));
    }

    public Builder<T> usingData(Preferences data) {
        return this.usingData(new BuilderPrefsDataSource(data));
    }

    public Builder<T> usingData(NvReadable data) {
        return this.usingData(new BuilderReadableDataSource(data));
    }

    public Builder<T> usingData(JSONObject data) {
        return this.usingData(new BuilderJsonDataSource(data));
    }

    public Builder<T> readingJsonData(InputStream data) {
        return this.usingData(new BuilderJsonDataSource(data));
    }

    public Builder<T> providingContext(Object context) {
        this.fContext = context;
        this.fContextClass = context.getClass();
        return this;
    }

    public Builder<T> allowFullClassnames() {
        this.fRestrictSearchToPath = false;
        return this;
    }

    public Builder<T> restrictFullClassnames() {
        this.fRestrictSearchToPath = true;
        return this;
    }

    public Builder<T> searchingPath(String packageName) {
        if (this.fSearchPath == null) {
            this.fSearchPath = new LinkedList();
        }
        this.fSearchPath.add(packageName);
        return this;
    }

    public Builder<T> searchingPaths(Collection<String> packageNames) {
        for (String pkgName : packageNames) {
            this.searchingPath(pkgName);
        }
        return this;
    }

    public T build() throws BuildFailure {
        try {
            String cn = null;
            if (this.fClassNameInData && this.fData != null) {
                cn = this.fData.getClassNameFromData();
            } else if (!this.fClassNameInData && this.fClassName != null) {
                cn = this.fClassName;
            }
            if (cn == null) {
                throw new BuildFailure("No class name provided.");
            }
            if (this.fData != null) {
                return this.build(cn);
            }
            return this.findClass(cn).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildFailure(e);
        }
        catch (InstantiationException e) {
            throw new BuildFailure(e);
        }
        catch (IllegalAccessException e) {
            throw new BuildFailure(e);
        }
    }

    private Class<? extends T> findClass(String className) throws ClassNotFoundException {
        block9: {
            if (!this.fRestrictSearchToPath) {
                try {
                    log.trace("Builder looking for " + className + " as " + this.fBase.getName());
                    return this.classForName(className).asSubclass(this.fBase);
                }
                catch (ClassCastException x) {
                    log.warn("{} does not implement {}.", (Object)className, (Object)this.fBase.getName());
                    throw x;
                }
                catch (ClassNotFoundException x1) {
                    if (this.fSearchPath != null) break block9;
                    log.trace("Didn't find " + className + ". No additional search path. Restricted to path: " + this.fRestrictSearchToPath);
                    throw x1;
                }
            }
        }
        for (String path : this.fSearchPath) {
            StringBuilder sb = new StringBuilder();
            sb.append(path);
            if (!path.endsWith(".")) {
                sb.append('.');
            }
            sb.append(className);
            String newClassName = sb.toString();
            log.trace("Builder looking for " + newClassName + " as " + this.fBase.getName());
            try {
                return this.classForName(newClassName).asSubclass(this.fBase);
            }
            catch (ClassCastException x) {
                log.warn("{} does not implement {}.", (Object)className, (Object)this.fBase.getName());
            }
            catch (ClassNotFoundException x2) {
                log.trace("Didn't find " + newClassName + " (or it's not a " + this.fBase.getName() + ").");
            }
        }
        log.trace("Didn't find " + className + ", even after using search path.");
        throw new ClassNotFoundException(className);
    }

    private <D> T build(String className) throws BuildFailure {
        try {
            Class<T> c = this.findClass(className);
            String initerName = this.fData.getIniterName();
            Class<?> initerDataClass = this.fData.getIniterClass();
            for (Method m : c.getMethods()) {
                if (!m.getName().equals(initerName) || !this.fBase.isAssignableFrom(m.getReturnType())) continue;
                boolean isStatic = Modifier.isStatic(m.getModifiers());
                Class<?>[] params = m.getParameterTypes();
                if (params.length == 1 && params[0].isAssignableFrom(initerDataClass)) {
                    if (isStatic) {
                        return (T)m.invoke(null, this.fData.getInitData());
                    }
                    T t = c.newInstance();
                    m.invoke(t, this.fData.getInitData());
                    return t;
                }
                if (params.length != 2 || !params[0].isAssignableFrom(initerDataClass) || this.fContextClass == null || !params[1].isAssignableFrom(this.fContextClass)) continue;
                if (isStatic) {
                    return (T)m.invoke(null, this.fData.getInitData(), this.fContext);
                }
                T t = c.newInstance();
                m.invoke(t, this.fData.getInitData(), this.fContext);
                return t;
            }
            if (this.fContext != null) {
                for (Class<? extends Object> contextClassToTry = this.fContextClass; contextClassToTry != null; contextClassToTry = contextClassToTry.getSuperclass()) {
                    try {
                        Constructor<T> cc = c.getConstructor(contextClassToTry, initerDataClass);
                        return cc.newInstance(this.fContext, this.fData.getInitData());
                    }
                    catch (NoSuchMethodException e) {
                        continue;
                    }
                }
                for (Class<?> iface : this.fContextClass.getInterfaces()) {
                    try {
                        Constructor<T> cc = c.getConstructor(iface, initerDataClass);
                        return cc.newInstance(this.fContext, this.fData.getInitData());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            try {
                Constructor<T> cc = c.getConstructor(initerDataClass);
                return cc.newInstance(this.fData.getInitData());
            }
            catch (NoSuchMethodException cc) {
                try {
                    Constructor<T> cc2 = c.getConstructor(new Class[0]);
                    return cc2.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new BuildFailure("Could not find a suitable constructor/creator for class [" + className + "]");
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new BuildFailure(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof BuildFailure) {
                BuildFailure f = (BuildFailure)target;
                throw f;
            }
            if (target == null) {
                throw new BuildFailure(e);
            }
            throw new BuildFailure(target);
        }
        catch (ClassNotFoundException e) {
            throw new BuildFailure(e);
        }
        catch (InstantiationException e) {
            throw new BuildFailure(e);
        }
        catch (IllegalAccessException e) {
            throw new BuildFailure(e);
        }
        catch (SecurityException e) {
            throw new BuildFailure(e);
        }
    }

    private Class<?> classForName(String className) throws ClassNotFoundException {
        if (this.fClassLoader != null) {
            return Class.forName(className, true, this.fClassLoader);
        }
        return Class.forName(className);
    }

    public static class BuildFailure
    extends Exception {
        private static final long serialVersionUID = 1L;

        public BuildFailure(Throwable t) {
            super(t);
        }

        public BuildFailure(String msg) {
            super(msg);
        }

        public BuildFailure(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

