/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.engine.processing.bpmn.ProcessInstanceLifecycle;
import io.camunda.zeebe.engine.state.instance.IndexedRecord;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.ObjectValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import org.agrona.DirectBuffer;

public final class ElementInstance
extends UnpackedObject
implements DbValue {
    private final LongProperty parentKeyProp = new LongProperty("parentKey", -1L);
    private final IntegerProperty childCountProp = new IntegerProperty("childCount", 0);
    private final IntegerProperty childActivatedCountProp = new IntegerProperty("childActivatedCount", 0);
    private final IntegerProperty childCompletedCountProp = new IntegerProperty("childCompletedCount", 0);
    private final IntegerProperty childTerminatedCountProp = new IntegerProperty("childTerminatedCount", 0);
    private final LongProperty jobKeyProp = new LongProperty("jobKey", 0L);
    private final IntegerProperty multiInstanceLoopCounterProp = new IntegerProperty("multiInstanceLoopCounter", 0);
    private final StringProperty interruptingEventKeyProp = new StringProperty("interruptingElementId", "");
    private final LongProperty calledChildInstanceKeyProp = new LongProperty("calledChildInstanceKey", -1L);
    private final ObjectProperty<IndexedRecord> recordProp = new ObjectProperty("elementRecord", (ObjectValue)new IndexedRecord());
    private final IntegerProperty activeSequenceFlowsProp = new IntegerProperty("activeSequenceFlows", 0);
    private final LongProperty userTaskKeyProp = new LongProperty("userTaskKey", -1L);

    public ElementInstance() {
        super(12);
        this.declareProperty((BaseProperty)this.parentKeyProp).declareProperty((BaseProperty)this.childCountProp).declareProperty((BaseProperty)this.childActivatedCountProp).declareProperty((BaseProperty)this.childCompletedCountProp).declareProperty((BaseProperty)this.childTerminatedCountProp).declareProperty((BaseProperty)this.jobKeyProp).declareProperty((BaseProperty)this.multiInstanceLoopCounterProp).declareProperty((BaseProperty)this.interruptingEventKeyProp).declareProperty((BaseProperty)this.calledChildInstanceKeyProp).declareProperty(this.recordProp).declareProperty((BaseProperty)this.activeSequenceFlowsProp).declareProperty((BaseProperty)this.userTaskKeyProp);
    }

    public ElementInstance(long key, ElementInstance parent, ProcessInstanceIntent state, ProcessInstanceRecord value) {
        this();
        ((IndexedRecord)this.recordProp.getValue()).setKey(key);
        ((IndexedRecord)this.recordProp.getValue()).setState(state);
        ((IndexedRecord)this.recordProp.getValue()).setValue(value);
        if (parent != null) {
            this.parentKeyProp.setValue(parent.getKey());
            parent.childCountProp.increment();
        }
    }

    public ElementInstance(long key, ProcessInstanceIntent state, ProcessInstanceRecord value) {
        this(key, null, state, value);
    }

    public long getKey() {
        return ((IndexedRecord)this.recordProp.getValue()).getKey();
    }

    public ProcessInstanceIntent getState() {
        return ((IndexedRecord)this.recordProp.getValue()).getState();
    }

    public void setState(ProcessInstanceIntent state) {
        ((IndexedRecord)this.recordProp.getValue()).setState(state);
    }

    public ProcessInstanceRecord getValue() {
        return ((IndexedRecord)this.recordProp.getValue()).getValue();
    }

    public void setValue(ProcessInstanceRecord value) {
        ((IndexedRecord)this.recordProp.getValue()).setValue(value);
    }

    public long getJobKey() {
        return this.jobKeyProp.getValue();
    }

    public void setJobKey(long jobKey) {
        this.jobKeyProp.setValue(jobKey);
    }

    public void decrementChildCount() {
        int childCount = this.childCountProp.decrement();
        if (childCount < 0) {
            throw new IllegalStateException(String.format("Expected the child count to be positive but was %d", childCount));
        }
    }

    public boolean canTerminate() {
        return ProcessInstanceLifecycle.canTerminate(this.getState());
    }

    public boolean isActive() {
        return ProcessInstanceLifecycle.isActive(this.getState());
    }

    public boolean isTerminating() {
        return ProcessInstanceLifecycle.isTerminating(this.getState());
    }

    public boolean isInFinalState() {
        return ProcessInstanceLifecycle.isFinalState(this.getState());
    }

    public int getNumberOfActiveElementInstances() {
        return this.childCountProp.getValue();
    }

    public int getNumberOfCompletedElementInstances() {
        return this.childCompletedCountProp.getValue();
    }

    public int getNumberOfElementInstances() {
        return this.childActivatedCountProp.getValue();
    }

    public int getNumberOfTerminatedElementInstances() {
        return this.childTerminatedCountProp.getValue();
    }

    public void incrementNumberOfCompletedElementInstances() {
        this.childCompletedCountProp.increment();
    }

    public void incrementNumberOfElementInstances() {
        this.childActivatedCountProp.increment();
    }

    public void incrementNumberOfTerminatedElementInstances() {
        this.childTerminatedCountProp.increment();
    }

    public int getMultiInstanceLoopCounter() {
        return this.multiInstanceLoopCounterProp.getValue();
    }

    public void setMultiInstanceLoopCounter(int loopCounter) {
        this.multiInstanceLoopCounterProp.setValue(loopCounter);
    }

    public void incrementMultiInstanceLoopCounter() {
        this.multiInstanceLoopCounterProp.increment();
    }

    public long getCalledChildInstanceKey() {
        return this.calledChildInstanceKeyProp.getValue();
    }

    public void setCalledChildInstanceKey(long calledChildInstanceKey) {
        this.calledChildInstanceKeyProp.setValue(calledChildInstanceKey);
    }

    public DirectBuffer getInterruptingElementId() {
        return this.interruptingEventKeyProp.getValue();
    }

    public void setInterruptingElementId(DirectBuffer elementId) {
        this.interruptingEventKeyProp.setValue(elementId);
    }

    public boolean isInterrupted() {
        return this.getInterruptingElementId().capacity() > 0;
    }

    public void clearInterruptedState() {
        this.interruptingEventKeyProp.setValue("");
    }

    public long getParentKey() {
        return this.parentKeyProp.getValue();
    }

    public long getActiveSequenceFlows() {
        return this.activeSequenceFlowsProp.getValue();
    }

    public void decrementActiveSequenceFlows() {
        if (this.getActiveSequenceFlows() > 0L) {
            this.activeSequenceFlowsProp.decrement();
        }
    }

    public void incrementActiveSequenceFlows() {
        this.activeSequenceFlowsProp.increment();
    }

    public void resetActiveSequenceFlows() {
        this.activeSequenceFlowsProp.setValue(0);
    }

    public long getUserTaskKey() {
        return this.userTaskKeyProp.getValue();
    }

    public void setUserTaskKey(long userTaskKey) {
        this.userTaskKeyProp.setValue(userTaskKey);
    }
}

