/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.deployment.VersionManager;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public class DbFormState
implements MutableFormState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final DbString tenantIdKey = new DbString();
    private final DbLong dbFormKey = new DbLong();
    private final DbTenantAwareKey<DbLong> tenantAwareFormKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbFormKey, DbTenantAwareKey.PlacementType.PREFIX);
    private final PersistedForm dbPersistedForm = new PersistedForm();
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedForm> formsByKey;
    private final DbString dbFormId;
    private final VersionManager versionManager;
    private final DbLong formVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareIdAndVersionKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, PersistedForm> formByIdAndVersionColumnFamily;
    private final Object2ObjectHashMap<TenantIdAndFormId, PersistedForm> formByTenantAndIdCache;

    public DbFormState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.formsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.FORMS, transactionContext, this.tenantAwareFormKey, (DbValue)this.dbPersistedForm);
        this.dbFormId = new DbString();
        this.formVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.dbFormId, (DbKey)this.formVersion);
        this.tenantAwareIdAndVersionKey = new DbTenantAwareKey(this.tenantIdKey, this.idAndVersionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.formByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.FORM_BY_ID_AND_VERSION, transactionContext, this.tenantAwareIdAndVersionKey, (DbValue)this.dbPersistedForm);
        this.versionManager = new VersionManager(0L, zeebeDb, ZbColumnFamilies.FORM_VERSION, transactionContext);
        this.formByTenantAndIdCache = new Object2ObjectHashMap();
    }

    @Override
    public void storeFormInFormColumnFamily(FormRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbFormKey.wrapLong(record.getFormKey());
        this.dbPersistedForm.wrap(record);
        this.formsByKey.upsert(this.tenantAwareFormKey, (DbValue)this.dbPersistedForm);
        this.formByTenantAndIdCache.put((Object)new TenantIdAndFormId(record.getTenantId(), record.getFormIdBuffer()), (Object)this.dbPersistedForm.copy());
    }

    @Override
    public void storeFormInFormByIdAndVersionColumnFamily(FormRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbFormId.wrapString(record.getFormId());
        this.formVersion.wrapLong((long)record.getVersion());
        this.dbPersistedForm.wrap(record);
        this.formByIdAndVersionColumnFamily.upsert(this.tenantAwareIdAndVersionKey, (DbValue)this.dbPersistedForm);
    }

    @Override
    public void updateLatestVersion(FormRecord record) {
        this.versionManager.addResourceVersion(record.getFormId(), record.getVersion(), record.getTenantId());
    }

    @Override
    public void deleteFormInFormsColumnFamily(FormRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbFormKey.wrapLong(record.getFormKey());
        this.formsByKey.deleteExisting(this.tenantAwareFormKey);
        this.formByTenantAndIdCache.remove((Object)new TenantIdAndFormId(record.getTenantId(), record.getFormIdBuffer()));
    }

    @Override
    public void deleteFormInFormByIdAndVersionColumnFamily(FormRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbFormId.wrapString(record.getFormId());
        this.formVersion.wrapLong((long)record.getVersion());
        this.formByIdAndVersionColumnFamily.deleteExisting(this.tenantAwareIdAndVersionKey);
    }

    @Override
    public void deleteFormInFormVersionColumnFamily(FormRecord record) {
        this.versionManager.deleteResourceVersion(record.getFormId(), record.getVersion(), record.getTenantId());
    }

    @Override
    public Optional<PersistedForm> findLatestFormById(DirectBuffer formId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        PersistedForm cachedForm = (PersistedForm)((Object)this.formByTenantAndIdCache.get((Object)new TenantIdAndFormId(tenantId, formId)));
        if (cachedForm != null) {
            return Optional.of(cachedForm);
        }
        this.dbFormId.wrapBuffer(formId);
        long latestVersion = this.versionManager.getLatestResourceVersion(formId, tenantId);
        this.formVersion.wrapLong(latestVersion);
        PersistedForm persistedForm = (PersistedForm)this.formByIdAndVersionColumnFamily.get(this.tenantAwareIdAndVersionKey);
        if (persistedForm == null) {
            return Optional.empty();
        }
        PersistedForm copiedForm = persistedForm.copy();
        this.formByTenantAndIdCache.put((Object)new TenantIdAndFormId(tenantId, formId), (Object)copiedForm);
        return Optional.of(copiedForm);
    }

    @Override
    public Optional<PersistedForm> findFormByKey(long formKey, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbFormKey.wrapLong(formKey);
        return Optional.ofNullable((PersistedForm)this.formsByKey.get(this.tenantAwareFormKey)).map(PersistedForm::copy);
    }

    @Override
    public int getNextFormVersion(String formId, String tenantId) {
        return (int)this.versionManager.getHighestResourceVersion(formId, tenantId) + 1;
    }

    @Override
    public void clearCache() {
        this.formByTenantAndIdCache.clear();
        this.versionManager.clear();
    }

    private record TenantIdAndFormId(String tenantId, DirectBuffer formId) {
    }
}

