/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskProcessor;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;

public abstract class JobWorkerTaskSupportingProcessor<T extends ExecutableJobWorkerTask>
implements BpmnElementProcessor<T> {
    private final JobWorkerTaskProcessor delegate;

    public JobWorkerTaskSupportingProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.delegate = new JobWorkerTaskProcessor(bpmnBehaviors, stateTransitionBehavior);
    }

    @Override
    public void onActivate(T element, BpmnElementContext context) {
        if (this.isJobBehavior(element, context)) {
            this.delegate.onActivate((ExecutableJobWorkerTask)element, context);
        } else {
            this.onActivateInternal(element, context);
        }
    }

    @Override
    public void onComplete(T element, BpmnElementContext context) {
        if (this.isJobBehavior(element, context)) {
            this.delegate.onComplete((ExecutableJobWorkerTask)element, context);
        } else {
            this.onCompleteInternal(element, context);
        }
    }

    @Override
    public void onTerminate(T element, BpmnElementContext context) {
        if (this.isJobBehavior(element, context)) {
            this.delegate.onTerminate((ExecutableJobWorkerTask)element, context);
        } else {
            this.onTerminateInternal(element, context);
        }
    }

    protected abstract boolean isJobBehavior(T var1, BpmnElementContext var2);

    protected abstract void onActivateInternal(T var1, BpmnElementContext var2);

    protected abstract void onCompleteInternal(T var1, BpmnElementContext var2);

    protected abstract void onTerminateInternal(T var1, BpmnElementContext var2);
}

