/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.camunda.zeebe.util.LogUtil;
import io.camunda.zeebe.util.logging.RecordingAppender;
import io.camunda.zeebe.util.logging.StackdriverLayout;
import io.camunda.zeebe.util.logging.stackdriver.Severity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.OutputStreamAppender;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Constants;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.JUnitSoftAssertions;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StackdriverLayoutTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StackdriverLayoutTest.class);
    private static final ObjectReader OBJECT_READER = new ObjectMapper().reader();
    private static final String SERVICE = "test-service";
    private static final String VERSION = "test-version";
    @Rule
    public JUnitSoftAssertions softly = new JUnitSoftAssertions();
    private org.apache.logging.log4j.core.Logger logger;
    private PipedInputStream source;
    private PipedOutputStream sink;
    private RecordingAppender appender;

    @Before
    public void before() throws IOException {
        this.sink = new PipedOutputStream();
        this.source = new PipedInputStream(524288);
        this.logger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger();
        StackdriverLayout layout = StackdriverLayout.newBuilder().setServiceName(SERVICE).setServiceVersion(VERSION).build();
        this.appender = this.createAndStartAppender((Layout<?>)layout, this.sink);
        this.logger.addAppender((Appender)this.appender);
        this.sink.connect(this.source);
        this.logger.setLevel(Level.DEBUG);
    }

    @After
    public void tearDown() {
        try {
            this.source.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close source input stream", (Throwable)e);
        }
        try {
            this.sink.close();
        }
        catch (IOException e) {
            LOGGER.error("Failed to close sink output stream", (Throwable)e);
        }
        this.logger.removeAppender((Appender)this.appender);
        this.appender.stop();
    }

    @Test
    public void shouldWriteTraceMessage() throws IOException {
        this.logger.setLevel(Level.TRACE);
        this.logger.trace("Trace message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.DEBUG.name());
    }

    @Test
    public void shouldWriteDebugMessages() throws IOException {
        this.logger.setLevel(Level.DEBUG);
        this.logger.debug("Debug message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.DEBUG.name());
    }

    @Test
    public void shouldWriteInfoMessage() throws IOException {
        this.logger.setLevel(Level.INFO);
        this.logger.info("Info message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.INFO.name());
    }

    @Test
    public void shouldWriteWarningMessage() throws IOException {
        this.logger.setLevel(Level.WARN);
        this.logger.warn("Info message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.WARNING.name());
    }

    @Test
    public void shouldWriteErrorMessageWithoutException() throws IOException {
        this.logger.setLevel(Level.ERROR);
        this.logger.error("Error message {}", (Object)1);
        StackTraceElement[] stackTrace = new IllegalStateException("").getStackTrace();
        StackTraceElement source = stackTrace[0];
        Map<String, Object> jsonMap = this.readLoggedEvent();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.ERROR.name())).containsEntry((Object)"message", (Object)"Error message 1")).containsEntry((Object)"@type", (Object)"type.googleapis.com/google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent")).hasEntrySatisfying((Object)"context", context -> ((MapAssert)this.softly.assertThat(context).asInstanceOf(InstanceOfAssertFactories.MAP)).hasEntrySatisfying((Object)"reportLocation", reportLocation -> ((MapAssert)((MapAssert)((MapAssert)this.softly.assertThat(reportLocation).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"filePath", (Object)source.getFileName())).containsEntry((Object)"functionName", (Object)source.getMethodName())).containsEntry((Object)"lineNumber", (Object)(source.getLineNumber() - 1))))).doesNotContainKey((Object)"exception");
    }

    @Test
    public void shouldWriteErrorMessageWithException() throws IOException {
        this.logger.setLevel(Level.ERROR);
        ThrowableProxy exception = new ThrowableProxy((Throwable)new IllegalStateException("Failed"));
        this.logger.error("Error message", exception.getThrowable());
        Map<String, Object> jsonMap = this.readLoggedEvent();
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)this.softly.assertThat(jsonMap).containsEntry((Object)"severity", (Object)Severity.ERROR.name())).containsEntry((Object)"message", (Object)"Error message")).containsEntry((Object)"@type", (Object)"type.googleapis.com/google.devtools.clouderrorreporting.v1beta1.ReportedErrorEvent")).containsEntry((Object)"exception", (Object)exception.getExtendedStackTraceAsString())).hasEntrySatisfying((Object)"context", context -> ((MapAssert)this.softly.assertThat(context).asInstanceOf(InstanceOfAssertFactories.MAP)).doesNotContainKey((Object)"reportLocation"));
    }

    @Test
    public void shouldContainFormattedMessage() throws IOException {
        String expectedMessage = "This is an ultra message";
        this.logger.info("This is an {} message", (Object)"ultra");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"message", (Object)"This is an ultra message");
    }

    @Test
    public void shouldContainTime() throws IOException {
        this.logger.info("This is a message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        LogEvent event = (LogEvent)this.appender.getAppendedEvents().get(0);
        long timestampSeconds = ((Number)jsonMap.get("timestampSeconds")).longValue();
        long timestampNanos = ((Number)jsonMap.get("timestampNanos")).longValue();
        this.softly.assertThat(timestampSeconds).isEqualTo(event.getInstant().getEpochSecond());
        this.softly.assertThat(timestampNanos).isEqualTo((long)event.getInstant().getNanoOfSecond());
    }

    @Test
    public void shouldTerminateAllEntriesWithALineSeparator() throws IOException {
        String lineSeparator = System.lineSeparator();
        this.logger.info("Should be terminated with a line separator");
        byte[] rawOutput = this.source.readNBytes(this.source.available());
        this.softly.assertThat(new String(rawOutput)).endsWith((CharSequence)lineSeparator);
    }

    @Test
    public void shouldContainSourceLocation() throws IOException {
        this.logger.info("Message");
        StackTraceElement[] stackTrace = new IllegalStateException("").getStackTrace();
        StackTraceElement source = stackTrace[0];
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).hasEntrySatisfying((Object)"logging.googleapis.com/sourceLocation", sourceLocation -> ((MapAssert)((MapAssert)((MapAssert)this.softly.assertThat(sourceLocation).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"file", (Object)source.getFileName())).containsEntry((Object)"function", (Object)source.getMethodName())).containsEntry((Object)"line", (Object)(source.getLineNumber() - 1)));
    }

    @Test
    public void shouldContainServiceContext() throws IOException {
        this.logger.info("Message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).hasEntrySatisfying((Object)"serviceContext", serviceContext -> ((MapAssert)((MapAssert)this.softly.assertThat(serviceContext).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"service", (Object)SERVICE)).containsEntry((Object)"version", (Object)VERSION));
    }

    @Test
    public void shouldContainContext() throws IOException {
        Map<String, String> expectedContext = Map.of("foo", "bar", "baz", "boz");
        LogUtil.doWithMDC(expectedContext, () -> this.logger.info("Message"));
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).hasEntrySatisfying((Object)"context", context -> ((MapAssert)this.softly.assertThat(context).asInstanceOf(InstanceOfAssertFactories.MAP)).containsAllEntriesOf(expectedContext));
    }

    @Test
    public void shouldContainThreadInfo() throws IOException {
        Thread currentThread = Thread.currentThread();
        this.logger.setLevel(Level.INFO);
        this.logger.info("Message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).hasEntrySatisfying((Object)"context", context -> ((MapAssert)((MapAssert)((MapAssert)this.softly.assertThat(context).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"threadName", (Object)currentThread.getName())).containsEntry((Object)"threadId", (Object)((int)currentThread.getId()))).containsEntry((Object)"threadPriority", (Object)currentThread.getPriority()));
    }

    @Test
    public void shouldContainLogger() throws IOException {
        this.logger.setLevel(Level.INFO);
        this.logger.info("Message");
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).hasEntrySatisfying((Object)"context", context -> ((MapAssert)this.softly.assertThat(context).asInstanceOf(InstanceOfAssertFactories.MAP)).containsEntry((Object)"loggerName", (Object)this.logger.getName()));
    }

    @Test
    public void shouldWriteLargeMessageWithoutOverflow() throws IOException {
        int largeMessageSize = Constants.ENCODER_BYTE_BUFFER_SIZE * 2;
        String largeMessage = "a".repeat(largeMessageSize);
        this.logger.info(largeMessage);
        Map<String, Object> jsonMap = this.readLoggedEvent();
        this.softly.assertThat(jsonMap).containsEntry((Object)"message", (Object)largeMessage);
    }

    private Map<String, Object> readLoggedEvent() throws IOException {
        return (Map)OBJECT_READER.withValueToUpdate(new HashMap()).readValue((InputStream)this.source);
    }

    private RecordingAppender createAndStartAppender(Layout<?> layout, OutputStream logTarget) {
        OutputStreamAppender appender = OutputStreamAppender.createAppender(layout, null, (OutputStream)logTarget, (String)"test", (boolean)false, (boolean)false);
        RecordingAppender recordingAppender = new RecordingAppender((Appender)appender);
        recordingAppender.start();
        return recordingAppender;
    }
}

