/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import io.camunda.zeebe.util.health.MemoryHealthIndicator;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;
import org.junit.Test;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class MemoryHealthIndicatorTest {
    @Test
    public void shouldRejectNegativeThreshold() {
        Assertions.assertThatThrownBy(() -> new MemoryHealthIndicator(-0.5)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldRejectZeroThreshold() {
        Assertions.assertThatThrownBy(() -> new MemoryHealthIndicator(0.0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldRejectOneThreshold() {
        Assertions.assertThatThrownBy(() -> new MemoryHealthIndicator(1.0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldRejectGreaterThanOneThreshold() {
        Assertions.assertThatThrownBy(() -> new MemoryHealthIndicator(1.5)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldUseThresholdPassedInThroughConstructor() {
        MemoryHealthIndicator sutHealthIndicaor = new MemoryHealthIndicator(0.5);
        double actual = sutHealthIndicaor.getThreshold();
        Assertions.assertThat((double)actual).isEqualTo(0.5, Offset.offset((Number)0.001));
    }

    @Test
    public void shouldReturnUpWhenEnoughAvailableMemory() {
        double availablePercentageCurrently = this.getAvailablePercentageCurrently();
        double thresholdBelowCurrentLevel = availablePercentageCurrently * 0.9;
        MemoryHealthIndicator sutHealthIndicator = new MemoryHealthIndicator(thresholdBelowCurrentLevel);
        Health actual = sutHealthIndicator.health();
        Assertions.assertThat((Object)actual.getStatus()).isSameAs((Object)Status.UP);
    }

    @Test
    public void shouldReturnDownWhenNotEnoughAvailableMemory() {
        double availablePercentageCurrently = this.getAvailablePercentageCurrently();
        double thresholdAboveCurrentLevel = (1.0 - availablePercentageCurrently) * 0.1 + availablePercentageCurrently;
        MemoryHealthIndicator sutHealthIndicator = new MemoryHealthIndicator(thresholdAboveCurrentLevel);
        Health actual = sutHealthIndicator.health();
        Assertions.assertThat((Object)actual.getStatus()).isSameAs((Object)Status.DOWN);
    }

    private double getAvailablePercentageCurrently() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long availableMemory = freeMemory + (maxMemory - totalMemory);
        return (double)availableMemory / (double)maxMemory;
    }
}

