/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import io.camunda.zeebe.util.health.DelayedHealthIndicator;
import java.time.Duration;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;

@RunWith(value=MockitoJUnitRunner.class)
public class DelayedHealthIndicatorTest {
    private static final Duration TEST_MAX_DOWNTIME = Duration.ofMillis(10L);
    @Mock
    private HealthIndicator mockHealthIndicator;

    @Test
    public void shouldRejectNullHealthIndicatorInConstructor() {
        Assertions.assertThatThrownBy(() -> new DelayedHealthIndicator(null, TEST_MAX_DOWNTIME)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void shouldRejectNullMaxDowntimeInConstructor() {
        Assertions.assertThatThrownBy(() -> new DelayedHealthIndicator(this.mockHealthIndicator, null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    public void shouldRejectNegativeMaxDowntimeInConstructor() {
        Assertions.assertThatThrownBy(() -> new DelayedHealthIndicator(this.mockHealthIndicator, Duration.ofMillis(-50L))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void shouldReportDownHealthStatusIfAskedBeforeDelegateHealthIndicatorWasCalled() {
        DelayedHealthIndicator sutDelayedHealthIndicator = new DelayedHealthIndicator(this.mockHealthIndicator, TEST_MAX_DOWNTIME);
        Health actualHealth = sutDelayedHealthIndicator.health();
        Assertions.assertThat((Object)actualHealth).isNotNull();
        Assertions.assertThat((Object)actualHealth.getStatus()).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void shouldReportHealthStatusOfDelegateHealthIndicatorIfBackendHealthIndicatorWasNeverUp() {
        DelayedHealthIndicator sutDelayedHealthIndicator = new DelayedHealthIndicator(this.mockHealthIndicator, TEST_MAX_DOWNTIME);
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.down().build());
        sutDelayedHealthIndicator.checkHealth();
        Health actualHealth = sutDelayedHealthIndicator.health();
        Assertions.assertThat((Object)actualHealth).isNotNull();
        Assertions.assertThat((Object)actualHealth.getStatus()).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void shouldReportHealthStatusUpWhenBackendHealthIndicatorWasUpInThePastAndIsTemporarilyDown() {
        TestCLock testClock = new TestCLock();
        DelayedHealthIndicator sutDelayedHealthIndicator = new DelayedHealthIndicator(this.mockHealthIndicator, TEST_MAX_DOWNTIME, (Supplier)testClock);
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.up().build());
        sutDelayedHealthIndicator.checkHealth();
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.down().build());
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() - 1L);
        sutDelayedHealthIndicator.checkHealth();
        Health actualHealth = sutDelayedHealthIndicator.health();
        Assertions.assertThat((Object)actualHealth).isNotNull();
        Assertions.assertThat((Object)actualHealth.getStatus()).isEqualTo((Object)Status.UP);
    }

    @Test
    public void shouldReportHealthStatusDownWhenBackendHealthIndicatorWasUpInThePastAndIsDownForMoreThanMaxDowntime() throws InterruptedException {
        TestCLock testClock = new TestCLock();
        DelayedHealthIndicator sutDelayedHealthIndicator = new DelayedHealthIndicator(this.mockHealthIndicator, TEST_MAX_DOWNTIME, (Supplier)testClock);
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.up().build());
        sutDelayedHealthIndicator.checkHealth();
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.down().build());
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() - 1L);
        sutDelayedHealthIndicator.checkHealth();
        Health actualHealthImmediate = sutDelayedHealthIndicator.health();
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() + 1L);
        sutDelayedHealthIndicator.checkHealth();
        Health actualHealthAfterDelay = sutDelayedHealthIndicator.health();
        Assertions.assertThat((Object)actualHealthImmediate).isNotNull();
        Assertions.assertThat((Object)actualHealthImmediate.getStatus()).isEqualTo((Object)Status.UP);
        Assertions.assertThat((Object)actualHealthAfterDelay).isNotNull();
        Assertions.assertThat((Object)actualHealthAfterDelay.getStatus()).isEqualTo((Object)Status.DOWN);
    }

    @Test
    public void shouldReportHealthStatusUpWhenBackendHealthIndicatorGoesDownTemporarilyButComesUpBeforeTheMaxDowntimeExpired() throws InterruptedException {
        TestCLock testClock = new TestCLock();
        DelayedHealthIndicator sutDelayedHealthIndicator = new DelayedHealthIndicator(this.mockHealthIndicator, TEST_MAX_DOWNTIME, (Supplier)testClock);
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.up().build());
        sutDelayedHealthIndicator.checkHealth();
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.down().build());
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() - 5L);
        sutDelayedHealthIndicator.checkHealth();
        Health actualHealthImmediate = sutDelayedHealthIndicator.health();
        Mockito.when((Object)this.mockHealthIndicator.health()).thenReturn((Object)Health.up().build());
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() - 1L);
        sutDelayedHealthIndicator.checkHealth();
        testClock.setTime(TEST_MAX_DOWNTIME.toMillis() + 1L);
        Health actualHealthAfterDelay = sutDelayedHealthIndicator.health();
        Assertions.assertThat((Object)actualHealthImmediate).isNotNull();
        Assertions.assertThat((Object)actualHealthImmediate.getStatus()).isEqualTo((Object)Status.UP);
        Assertions.assertThat((Object)actualHealthAfterDelay).isNotNull();
        Assertions.assertThat((Object)actualHealthAfterDelay.getStatus()).isEqualTo((Object)Status.UP);
    }

    private static final class TestCLock
    implements Supplier<Long> {
        private long time = 0L;

        private TestCLock() {
        }

        public void setTime(long time) {
            this.time = time;
        }

        @Override
        public Long get() {
            return this.time;
        }
    }
}

