/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.collection;

import io.camunda.zeebe.util.collection.Reusable;
import io.camunda.zeebe.util.collection.ReusableObjectList;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class ReusableObjectListTest {
    @Test
    public void shouldAddNewValue() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        Assertions.assertThat((int)reusableObjectList.size()).isEqualTo(1);
        Iterator iterator = reusableObjectList.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(1);
    }

    @Test
    public void shouldAddNewBunchOfValues() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        int workCount = 10000;
        for (int i = 0; i < 10000; ++i) {
            ((MutableInt)reusableObjectList.add()).setValue(i);
        }
        Assertions.assertThat((int)reusableObjectList.size()).isEqualTo(10000);
        int count = 0;
        for (MutableInt next : reusableObjectList) {
            Assertions.assertThat((int)next.getValue()).isEqualTo(count);
            ++count;
        }
    }

    @Test
    public void shouldRemoveValueViaIterator() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Iterator iterator = reusableObjectList.iterator();
        MutableInt removedValue = (MutableInt)iterator.next();
        iterator.remove();
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(0);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldEmptyListViaPollValue() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(2);
        MutableInt removedValue = (MutableInt)reusableObjectList.poll();
        Assertions.assertThat((int)reusableObjectList.size()).isEqualTo(0);
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(2);
        Iterator iterator = reusableObjectList.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldPollValue() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        MutableInt removedValue = (MutableInt)reusableObjectList.poll();
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(1);
        Iterator iterator = reusableObjectList.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldRemoveValueViaIteratorAndResetIterator() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Iterator iterator = reusableObjectList.iterator();
        MutableInt removedValue = (MutableInt)iterator.next();
        iterator.remove();
        iterator = reusableObjectList.iterator();
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(0);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldRemoveValueFromList() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Iterator iterator = reusableObjectList.iterator();
        MutableInt removedValue = (MutableInt)iterator.next();
        reusableObjectList.remove((Reusable)removedValue);
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(0);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldRemoveValueFromListAndResetIterator() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Iterator iterator = reusableObjectList.iterator();
        MutableInt removedValue = (MutableInt)iterator.next();
        reusableObjectList.remove((Reusable)removedValue);
        iterator = reusableObjectList.iterator();
        Assertions.assertThat((int)removedValue.getValue()).isEqualTo(0);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldClearList() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        reusableObjectList.clear();
        Assertions.assertThat((int)reusableObjectList.size()).isEqualTo(0);
        Iterator iterator = reusableObjectList.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void shouldAddAfterClearList() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        reusableObjectList.clear();
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Assertions.assertThat((int)reusableObjectList.size()).isEqualTo(1);
        Iterator iterator = reusableObjectList.iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
    }

    @Test
    public void shouldReuseObjectForNewValue() {
        ReusableObjectList reusableObjectList = new ReusableObjectList(() -> new MutableInt(this));
        ((MutableInt)reusableObjectList.add()).setValue(1);
        ((MutableInt)reusableObjectList.add()).setValue(2);
        Iterator iterator = reusableObjectList.iterator();
        MutableInt reusedObject = (MutableInt)iterator.next();
        iterator.remove();
        ((MutableInt)reusableObjectList.add()).setValue(3);
        Assertions.assertThat((int)reusedObject.getValue()).isEqualTo(3);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        MutableInt next = (MutableInt)iterator.next();
        Assertions.assertThat((int)next.getValue()).isEqualTo(2);
        Iterator resetedIterator = reusableObjectList.iterator();
        MutableInt firstValue = (MutableInt)resetedIterator.next();
        Assertions.assertThat((firstValue == reusedObject ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)firstValue.getValue()).isEqualTo(3);
        MutableInt secondValue = (MutableInt)resetedIterator.next();
        Assertions.assertThat((int)secondValue.getValue()).isEqualTo(2);
        Assertions.assertThat((boolean)resetedIterator.hasNext()).isFalse();
    }

    private final class MutableInt
    implements Reusable {
        private int value;

        private MutableInt(ReusableObjectListTest reusableObjectListTest) {
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public void reset() {
            this.value = 0;
        }
    }
}

