/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.buffer;

import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.ExpandableDirectByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class BufferUtilTest {
    protected static final byte[] BYTES1 = StringUtil.getBytes((String)"foo");
    protected static final byte[] BYTES2 = StringUtil.getBytes((String)"bar");
    protected static final byte[] BYTES3 = new byte[BYTES1.length + BYTES2.length];

    @Test
    public void testEquals() {
        Assertions.assertThat((boolean)BufferUtil.contentsEqual((DirectBuffer)this.asBuffer(BYTES1), (DirectBuffer)this.asBuffer(BYTES1))).isTrue();
        Assertions.assertThat((boolean)BufferUtil.contentsEqual((DirectBuffer)this.asBuffer(BYTES1), (DirectBuffer)this.asBuffer(BYTES2))).isFalse();
        Assertions.assertThat((boolean)BufferUtil.contentsEqual((DirectBuffer)this.asBuffer(BYTES1), (DirectBuffer)this.asBuffer(BYTES3))).isFalse();
        Assertions.assertThat((boolean)BufferUtil.contentsEqual((DirectBuffer)this.asBuffer(BYTES3), (DirectBuffer)this.asBuffer(BYTES1))).isFalse();
    }

    @Test
    public void testCloneUnsafeBuffer() {
        UnsafeBuffer src = new UnsafeBuffer(BYTES1);
        DirectBuffer dst = BufferUtil.cloneBuffer((DirectBuffer)src);
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)dst).isNotSameAs((Object)src)).isEqualTo((Object)src)).hasSameClassAs((Object)src);
    }

    @Test
    public void testCloneExpandableArrayBuffer() {
        ExpandableArrayBuffer src = new ExpandableArrayBuffer(BYTES1.length);
        src.putBytes(0, BYTES1);
        DirectBuffer dst = BufferUtil.cloneBuffer((DirectBuffer)src);
        ((AbstractComparableAssert)((AbstractComparableAssert)Assertions.assertThat((Comparable)dst).isNotSameAs((Object)src)).isEqualTo((Object)src)).hasSameClassAs((Object)src);
    }

    @Test
    public void shouldReturnCopyOfByteArrayWhenWrappingPartialArray() {
        byte[] expected = new byte[BYTES1.length - 1];
        UnsafeBuffer buffer = new UnsafeBuffer();
        buffer.wrap(BYTES1, 1, BYTES1.length - 1);
        byte[] bytes = BufferUtil.bufferAsArray((DirectBuffer)buffer);
        System.arraycopy(BYTES1, 1, expected, 0, expected.length);
        Assertions.assertThat((byte[])buffer.byteArray()).isEqualTo((Object)BYTES1);
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)expected);
        Assertions.assertThat((byte[])bytes).isNotEqualTo((Object)BYTES1);
    }

    @Test
    public void shouldReturnNewByteArrayWhenNotWrappingByteArray() {
        ExpandableDirectByteBuffer buffer = new ExpandableDirectByteBuffer();
        buffer.putBytes(0, BYTES1);
        byte[] bytes = BufferUtil.bufferAsArray((DirectBuffer)buffer);
        Assertions.assertThat((byte[])buffer.byteArray()).isNull();
        for (int i = 0; i < BYTES1.length; ++i) {
            Assertions.assertThat((byte)bytes[i]).isEqualTo(buffer.getByte(i));
        }
    }

    @Test
    public void shouldNotReturnWrappedArrayIfBufferOffsetIsZero() {
        UnsafeBuffer buffer = new UnsafeBuffer(BYTES1);
        byte[] bytes = BufferUtil.bufferAsArray((DirectBuffer)buffer);
        Assertions.assertThat((byte[])buffer.byteArray()).isEqualTo((Object)BYTES1);
        Assertions.assertThat((byte[])bytes).isNotSameAs((Object)BYTES1);
    }

    public DirectBuffer asBuffer(byte[] bytes) {
        return new UnsafeBuffer(bytes);
    }

    static {
        System.arraycopy(BYTES1, 0, BYTES3, 0, BYTES1.length);
        System.arraycopy(BYTES2, 0, BYTES3, BYTES1.length, BYTES2.length);
    }
}

