/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.StringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class StringUtilListSanitizerTest {
    @Test
    public void shouldReturnEmptyListForNull() {
        Object input = null;
        List expected = Collections.emptyList();
        List actual = (List)StringUtil.LIST_SANITIZER.apply(input);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void shouldRemoveNulls() {
        List<String> input = Arrays.asList("foo", null);
        List<String> expected = Arrays.asList("foo");
        List actual = (List)StringUtil.LIST_SANITIZER.apply(input);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void shouldRemoveEmptyStrings() {
        List<String> input = Arrays.asList("foo", "", "   ");
        List<String> expected = Arrays.asList("foo");
        List actual = (List)StringUtil.LIST_SANITIZER.apply(input);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void shouldReturnTrimmedEntries() {
        List<String> input = Arrays.asList("foo ", " bar");
        List<String> expected = Arrays.asList("foo", "bar");
        List actual = (List)StringUtil.LIST_SANITIZER.apply(input);
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }
}

