/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.SemanticVersion;
import io.camunda.zeebe.util.VersionUtil;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class SemanticVersionTest {
    SemanticVersionTest() {
    }

    @Test
    void shouldParseCurrentVersion() {
        Assertions.assertThat((Optional)SemanticVersion.parse((String)VersionUtil.getVersion())).isPresent();
    }

    @Test
    void shouldParseBasicSemanticVersions() {
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3")).contains((Object)new SemanticVersion(1, 2, 3, null, null));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"0.0.0")).contains((Object)new SemanticVersion(0, 0, 0, null, null));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"10.20.30")).contains((Object)new SemanticVersion(10, 20, 30, null, null));
    }

    @Test
    void shouldParseVersionsWithPreRelease() {
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-alpha")).contains((Object)new SemanticVersion(1, 2, 3, "alpha", null));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-beta")).contains((Object)new SemanticVersion(1, 2, 3, "beta", null));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-rc")).contains((Object)new SemanticVersion(1, 2, 3, "rc", null));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-SNAPSHOT")).contains((Object)new SemanticVersion(1, 2, 3, "SNAPSHOT", null));
    }

    @Test
    void shouldParseVersionsWithBuildMetadata() {
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3+build")).contains((Object)new SemanticVersion(1, 2, 3, null, "build"));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3+build.1")).contains((Object)new SemanticVersion(1, 2, 3, null, "build.1"));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3+build.1.2")).contains((Object)new SemanticVersion(1, 2, 3, null, "build.1.2"));
    }

    @Test
    void shouldParseVersionsWithPreReleaseAndBuildMetadata() {
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-alpha+build")).contains((Object)new SemanticVersion(1, 2, 3, "alpha", "build"));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-alpha+build.1")).contains((Object)new SemanticVersion(1, 2, 3, "alpha", "build.1"));
        Assertions.assertThat((Optional)SemanticVersion.parse((String)"1.2.3-alpha+build.1.2")).contains((Object)new SemanticVersion(1, 2, 3, "alpha", "build.1.2"));
    }

    @Test
    void shouldCompareBasicVersions() {
        Assertions.assertThat((Comparable)new SemanticVersion(1, 2, 3, null, null)).isLessThan((Comparable)new SemanticVersion(1, 2, 4, null, null)).isLessThan((Comparable)new SemanticVersion(1, 3, 7, null, null)).isLessThan((Comparable)new SemanticVersion(2, 4, 0, null, null));
    }

    @Test
    void shouldCompareVersionsWithPreRelease() {
        Assertions.assertThat((Comparable)new SemanticVersion(1, 2, 3, "alpha", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "alpha.1", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "alpha.beta", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "beta", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "beta.2", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "beta.11", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, "rc.1", null)).isLessThan((Comparable)new SemanticVersion(1, 2, 3, null, null));
    }

    @Test
    void shouldCompareVersionsWithBuildMetadata() {
        Assertions.assertThat((Comparable)new SemanticVersion(1, 0, 0, "alpha", "build.1")).isEqualByComparingTo((Comparable)new SemanticVersion(1, 0, 0, "alpha", "build.2"));
    }
}

