/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class FileUtilTest {
    @TempDir
    private Path tmpDir;

    FileUtilTest() {
    }

    @Test
    void shouldDeleteFolder() throws IOException {
        Files.createFile(this.tmpDir.resolve("file1"), new FileAttribute[0]);
        Files.createFile(this.tmpDir.resolve("file2"), new FileAttribute[0]);
        Files.createDirectory(this.tmpDir.resolve("testFolder"), new FileAttribute[0]);
        FileUtil.deleteFolder((Path)this.tmpDir);
        Assertions.assertThat((Path)this.tmpDir).doesNotExist();
    }

    @Test
    void shouldThrowExceptionForNonExistingFolder() throws IOException {
        Path root = Files.createDirectory(this.tmpDir.resolve("other"), new FileAttribute[0]);
        Files.delete(root);
        Assertions.assertThatThrownBy(() -> FileUtil.deleteFolder((Path)root)).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    void shouldNotThrowErrorIfFolderDoesNotExist() {
        Path nonExistent = this.tmpDir.resolve("something");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> FileUtil.deleteFolderIfExists((Path)nonExistent)).as("no error if folder does not exist", new Object[0])).doesNotThrowAnyException();
    }

    @Test
    void shouldNotDeleteContainingFolder() throws IOException {
        Files.createFile(this.tmpDir.resolve("file1"), new FileAttribute[0]);
        Files.createFile(this.tmpDir.resolve("file2"), new FileAttribute[0]);
        FileUtil.deleteFolderContents((Path)this.tmpDir);
        Assertions.assertThat((Path)this.tmpDir).exists().isEmptyDirectory();
    }

    @Test
    void shouldThrowExceptionWhenCopySnapshotForNonExistingFolder() {
        File source = this.tmpDir.resolve("src").toFile();
        File target = this.tmpDir.resolve("target").toFile();
        Assertions.assertThatThrownBy(() -> FileUtil.copySnapshot((Path)source.toPath(), (Path)target.toPath())).isInstanceOf(NoSuchFileException.class);
    }

    @Test
    void shouldThrowExceptionWhenyCopySnapshotIfTargetAlreadyExists() throws IOException {
        Path source = Files.createDirectory(this.tmpDir.resolve("src"), new FileAttribute[0]);
        Path target = Files.createDirectory(this.tmpDir.resolve("target"), new FileAttribute[0]);
        Assertions.assertThatThrownBy(() -> FileUtil.copySnapshot((Path)source, (Path)target)).isInstanceOf(FileAlreadyExistsException.class);
    }

    @Test
    void shouldCopySnapshot() throws Exception {
        String snapshotFile = "file1";
        Path source = Files.createDirectory(this.tmpDir.resolve("src"), new FileAttribute[0]);
        Path target = this.tmpDir.resolve("target");
        Files.createFile(source.resolve("file1"), new FileAttribute[0]);
        FileUtil.copySnapshot((Path)source, (Path)target);
        Assertions.assertThat(Files.list(target)).contains((Object[])new Path[]{target.resolve("file1")});
    }

    @Test
    void isEmptyReturnsTrueWhenDirectoryEmpty() throws IOException {
        Path emptyDirectory = Files.createDirectory(this.tmpDir.resolve("src"), new FileAttribute[0]);
        Assertions.assertThat((boolean)FileUtil.isEmpty((Path)emptyDirectory)).isTrue();
    }

    @Test
    void isEmptyReturnsTrueWhenDirectoryDoesNotExist() throws IOException {
        Path notExistingDirectory = this.tmpDir.resolve("src");
        Assertions.assertThat((boolean)FileUtil.isEmpty((Path)notExistingDirectory)).isTrue();
    }

    @Test
    void isEmptyReturnsFalseWhenPathIsNotDirectory() throws IOException {
        Path regularFile = Files.createFile(this.tmpDir.resolve("file"), new FileAttribute[0]);
        Assertions.assertThat((boolean)FileUtil.isEmpty((Path)regularFile)).isFalse();
    }
}

