/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import io.camunda.zeebe.util.Either;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class EitherTest {
    EitherTest() {
    }

    static Stream<Object> parameters() {
        return Stream.of(1, 123L, 123.456, Character.valueOf('c'), "something", "bytes".getBytes(), List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), new Object[]{1, 2L, "3"}, Either.right((Object)1), Either.left((Object)1));
    }

    static Stream<Collection<Either<Object, Object>>> collections() {
        return EitherTest.parameters().flatMap(value -> Stream.of(List.of(), List.of(Either.right((Object)value)), List.of(Either.left((Object)value)), List.of(Either.right((Object)value), Either.right((Object)value)), List.of(Either.right((Object)value), Either.left((Object)value)), List.of(Either.left((Object)value), Either.right((Object)value)), List.of(Either.left((Object)value), Either.left((Object)value)), List.of(Either.right((Object)value), Either.right((Object)value), Either.right((Object)value)), List.of(Either.right((Object)value), Either.right((Object)value), Either.left((Object)value)), List.of(Either.right((Object)value), Either.left((Object)value), Either.right((Object)value)), List.of(Either.right((Object)value), Either.left((Object)value), Either.left((Object)value)), List.of(Either.left((Object)value), Either.right((Object)value), Either.right((Object)value)), List.of(Either.left((Object)value), Either.right((Object)value), Either.left((Object)value)), List.of(Either.left((Object)value), Either.left((Object)value), Either.right((Object)value)), List.of(Either.left((Object)value), Either.left((Object)value), Either.left((Object)value))));
    }

    static Stream<Collection<Either<Object, Object>>> collectionsWithoutLefts() {
        return EitherTest.collections().filter(c -> c.stream().noneMatch(Either::isLeft));
    }

    static Stream<Collection<Either<Object, Object>>> collectionsWithLefts() {
        return EitherTest.collections().filter(c -> c.stream().anyMatch(Either::isLeft));
    }

    @DisplayName(value="Only a Right value can be retrieved with .get()")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyARightValueCanBeRetrievedWithGet(Object value) {
        Assertions.assertThat((Object)Either.right((Object)value).get()).isEqualTo(value);
        Assertions.assertThatThrownBy(() -> Either.left((Object)value).get()).isInstanceOf(NoSuchElementException.class);
    }

    @DisplayName(value="Only a Left value can retrieve the default value with .getOrElse(...)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyALeftValueCanReturnTheDefaultValueWithGetOrElse(Object value) {
        Integer defaultValue = 3;
        Assertions.assertThat((Object)Either.right((Object)value).getOrElse((Object)defaultValue)).isSameAs(value);
        Assertions.assertThat((Object)Either.left((Object)value).getOrElse((Object)defaultValue)).isSameAs((Object)defaultValue);
    }

    @DisplayName(value="Only a Left value can be retrieved with .getLeft()")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyALeftValueCanBeRetrievedWithGetLeft(Object value) {
        Assertions.assertThat((Object)Either.left((Object)value).getLeft()).isEqualTo(value);
        Assertions.assertThatThrownBy(() -> Either.right((Object)value).getLeft()).isInstanceOf(NoSuchElementException.class);
    }

    @DisplayName(value="Only a Right is Right")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyARightIsRight(Object value) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Either.right((Object)value).isRight()).as("a Right should have a right value", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Either.left((Object)value).isRight()).as("a Left should not have a right value", new Object[0])).isFalse();
    }

    @DisplayName(value="Only a Left is Left")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyALeftIsLeft(Object value) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Either.left((Object)value).isLeft()).as("a Left should have a right value", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)Either.right((Object)value).isLeft()).as("a Right should not have a right value", new Object[0])).isFalse();
    }

    @DisplayName(value="Only a Right is transformed by .map(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyARightIsTransformedByMap(Object value) {
        Function<Object, String> mapper = o -> "Transformed-" + o.toString();
        String mappedValue = mapper.apply(value);
        Assertions.assertThat((String)mappedValue).isNotEqualTo(value);
        Assertions.assertThat((Object)Either.right((Object)value).map(mapper)).isEqualTo((Object)Either.right((Object)mappedValue));
        Assertions.assertThat((Object)Either.left((Object)value).map(mapper)).isEqualTo((Object)Either.left((Object)value));
    }

    @DisplayName(value="Only a Left is transformed by .mapLeft(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyALeftIsTransformedByMapLeft(Object value) {
        Function<Object, String> mapper = o -> "Transformed-" + o.toString();
        String mappedValue = mapper.apply(value);
        Assertions.assertThat((String)mappedValue).isNotEqualTo(value);
        Assertions.assertThat((Object)Either.left((Object)value).mapLeft(mapper)).isEqualTo((Object)Either.left((Object)mappedValue));
        Assertions.assertThat((Object)Either.right((Object)value).mapLeft(mapper)).isEqualTo((Object)Either.right((Object)value));
    }

    @DisplayName(value="Only a Right is transformed by .flatMap(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyARightIsTransformedByFlatMap(Object value) {
        Assertions.assertThat((Object)Either.right((Object)value).flatMap(Either::left)).isEqualTo((Object)Either.left((Object)value));
        Assertions.assertThat((Object)Either.left((Object)value).flatMap(Either::right)).isEqualTo((Object)Either.left((Object)value));
    }

    @DisplayName(value="Only a Right is consumed by .ifRight(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyARightIsConsumedByIfRight(Object value) {
        VerifiableConsumer verifiableConsumer = new VerifiableConsumer();
        Either.right((Object)value).ifRight((Consumer)verifiableConsumer);
        Assertions.assertThat((boolean)verifiableConsumer.hasBeenExecuted).isTrue();
        Either.left((Object)value).ifRight((Consumer)new FailConsumer());
    }

    @DisplayName(value="Only a Left is consumed by .ifLeft(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyALeftIsConsumedByIfLeft(Object value) {
        VerifiableConsumer verifiableConsumer = new VerifiableConsumer();
        Either.left((Object)value).ifLeft((Consumer)verifiableConsumer);
        Assertions.assertThat((boolean)verifiableConsumer.hasBeenExecuted).isTrue();
        Either.right((Object)value).ifLeft((Consumer)new FailConsumer());
    }

    @DisplayName(value="Only one side is consumed by .ifRightOrLeft(..)")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyOneSideIsConsumedByIfRightOrLeft(Object value) {
        VerifiableConsumer rightConsumer = new VerifiableConsumer();
        Either.right((Object)value).ifRightOrLeft((Consumer)rightConsumer, (Consumer)new FailConsumer());
        Assertions.assertThat((boolean)rightConsumer.hasBeenExecuted).isTrue();
        VerifiableConsumer leftConsumer = new VerifiableConsumer();
        Either.left((Object)value).ifRightOrLeft((Consumer)new FailConsumer(), (Consumer)leftConsumer);
        Assertions.assertThat((boolean)leftConsumer.hasBeenExecuted).isTrue();
    }

    @DisplayName(value="Only an Either of Optional with a value present is a Right")
    @ParameterizedTest
    @MethodSource(value={"parameters"})
    void onlyAnEitherOfPresentOptionalIsRight(Object value) {
        Assertions.assertThat((Object)Either.ofOptional(Optional.of(value)).orElse(null)).isEqualTo((Object)Either.right((Object)value));
        Assertions.assertThat((Object)Either.ofOptional(Optional.empty()).orElse(value)).isEqualTo((Object)Either.left((Object)value));
    }

    private static final class VerifiableConsumer
    implements Consumer<Object> {
        boolean hasBeenExecuted = false;

        private VerifiableConsumer() {
        }

        @Override
        public void accept(Object o) {
            this.hasBeenExecuted = true;
        }
    }

    private static final class FailConsumer
    implements Consumer<Object> {
        private FailConsumer() {
        }

        @Override
        public void accept(Object o) {
            Assertions.fail((String)"Expected NOT to perform this action!");
        }
    }

    @DisplayName(value="`fold` method tests")
    @Nested
    class FoldMethodTests {
        FoldMethodTests(EitherTest this$0) {
        }

        @DisplayName(value="Folds `Left`s into target types using the left function.")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#parameters"})
        void foldsLeftsIntoTargetTypeUsingLeftFunction(Object value) {
            Function<Object, String> leftMapper = o -> "Expected-" + o.toString();
            Function<Object, String> rightMapper = o -> "Unexpected-" + o.toString();
            String mappedValue = leftMapper.apply(value);
            Assertions.assertThat((String)mappedValue).isNotEqualTo(value);
            Assertions.assertThat((String)((String)Either.left((Object)value).fold(leftMapper, rightMapper))).isEqualTo(mappedValue);
        }

        @DisplayName(value="Folds `Right`s into target types using the right function.")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#parameters"})
        void foldsRightsIntoTargetTypeUsingRightFunction(Object value) {
            Function<Object, String> leftMapper = o -> "Unexpected-" + o.toString();
            Function<Object, String> rightMapper = o -> "Expected-" + o.toString();
            String mappedValue = rightMapper.apply(value);
            Assertions.assertThat((String)mappedValue).isNotEqualTo(value);
            Assertions.assertThat((String)((String)Either.right((Object)value).fold(leftMapper, rightMapper))).isEqualTo(mappedValue);
        }
    }

    @DisplayName(value="`thenDo` method tests")
    @Nested
    class ThenDoMethodTests {
        ThenDoMethodTests(EitherTest this$0) {
        }

        @DisplayName(value="Executes the consumer action and returns the original `Either` when it is a `Right`")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#parameters"})
        void thenDoExecutesActionAndReturnsOriginalEitherWhenRight(Object value) {
            VerifiableConsumer verifiableConsumer = new VerifiableConsumer();
            Either originalRight = Either.right((Object)value);
            Either result = originalRight.thenDo((Consumer)verifiableConsumer);
            Assertions.assertThat((boolean)verifiableConsumer.hasBeenExecuted).isTrue();
            ((ObjectAssert)Assertions.assertThat((Object)result).as("Should return the original `Either` instance", new Object[0])).isSameAs((Object)originalRight);
            Assertions.assertThat((Object)result.get()).isEqualTo(value);
        }

        @DisplayName(value="Does not execute the consumer action and returns the original `Either` when it is a `Left`")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#parameters"})
        void thenDoDoesNotExecuteActionAndReturnsOriginalEitherWhenLeft(Object value) {
            VerifiableConsumer verifiableConsumer = new VerifiableConsumer();
            Either originalLeft = Either.left((Object)value);
            Either result = originalLeft.thenDo((Consumer)verifiableConsumer);
            Assertions.assertThat((boolean)verifiableConsumer.hasBeenExecuted).isFalse();
            ((ObjectAssert)Assertions.assertThat((Object)result).as("Should return the original `Either` instance", new Object[0])).isSameAs((Object)originalLeft);
            Assertions.assertThat((Object)result.getLeft()).isEqualTo(value);
        }
    }

    @DisplayName(value="Streams of Eithers can be collected using .collectorFoldingLeft()")
    @Nested
    class CollectorFoldingLeftTests {
        CollectorFoldingLeftTests(EitherTest this$0) {
        }

        @DisplayName(value="Only Streams without Lefts are collected into a Right")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#collectionsWithoutLefts"})
        void onlyStreamsWithoutLeftsAreCollectedIntoARight(List<Either<Object, Object>> collection) {
            Either collectedEither = (Either)collection.stream().collect(Either.collectorFoldingLeft());
            Assertions.assertThat((boolean)collectedEither.isRight()).isTrue();
            Assertions.assertThat((Object)collectedEither).extracting(Either::get).isEqualTo(collection.stream().filter(Predicate.not(Either::isLeft)).map(Either::get).collect(Collectors.toList()));
        }

        @DisplayName(value="Only Streams with Lefts are collected into a Left")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#collectionsWithLefts"})
        void onlyStreamsWithLeftsAreCollectedIntoALeft(List<Either<Object, Object>> collection) {
            Either collectedEither = (Either)collection.stream().collect(Either.collectorFoldingLeft());
            Assertions.assertThat((boolean)collectedEither.isLeft()).isTrue();
            Assertions.assertThat((Object)collectedEither).extracting(Either::getLeft).isEqualTo(collection.stream().filter(Either::isLeft).map(Either::getLeft).toList().get(0));
        }
    }

    @DisplayName(value="Streams of Eithers can be collected using .collector()")
    @Nested
    class CollectorTests {
        CollectorTests(EitherTest this$0) {
        }

        @DisplayName(value="Only Streams without Lefts are collected into a Right")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#collectionsWithoutLefts"})
        void onlyStreamsWithoutLeftsAreCollectedIntoARight(List<Either<Object, Object>> collection) {
            Either collectedEither = (Either)collection.stream().collect(Either.collector());
            Assertions.assertThat((boolean)collectedEither.isRight()).isTrue();
            Assertions.assertThat((Object)collectedEither).extracting(Either::get).isEqualTo(collection.stream().filter(Predicate.not(Either::isLeft)).map(Either::get).collect(Collectors.toList()));
        }

        @DisplayName(value="Only Streams with Lefts are collected into a Left")
        @ParameterizedTest
        @MethodSource(value={"io.camunda.zeebe.util.EitherTest#collectionsWithLefts"})
        void onlyStreamsWithLeftsAreCollectedIntoALeft(List<Either<Object, Object>> collection) {
            Either collectedEither = (Either)collection.stream().collect(Either.collector());
            Assertions.assertThat((boolean)collectedEither.isLeft()).isTrue();
            Assertions.assertThat((Object)collectedEither).extracting(Either::getLeft).isEqualTo(collection.stream().filter(Either::isLeft).map(Either::getLeft).collect(Collectors.toList()));
        }
    }
}

