/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public interface ScheduledTaskMetrics {
    public void incrementScheduledTasks();

    public void decrementScheduledTasks();

    public void observeScheduledTaskExecution(long var1);

    public static ScheduledTaskMetrics noop() {
        return new ScheduledTaskMetrics(){

            @Override
            public void incrementScheduledTasks() {
            }

            @Override
            public void decrementScheduledTasks() {
            }

            @Override
            public void observeScheduledTaskExecution(long delay) {
            }
        };
    }

    public static ScheduledTaskMetrics of(MeterRegistry registry) {
        return new ScheduledTaskMetricsImpl(registry);
    }

    public static final class ScheduledTaskMetricsImpl
    implements ScheduledTaskMetrics {
        private final LongAdder scheduledTasksCounter = new LongAdder();
        private final Timer scheduledTaskDelay;

        private ScheduledTaskMetricsImpl(MeterRegistry registry) {
            Gauge.builder((String)"zeebe.processing.scheduling.tasks", (Object)this.scheduledTasksCounter, LongAdder::sum).description("The number of currently scheduled tasks").register(registry);
            this.scheduledTaskDelay = Timer.builder((String)"zeebe.processing.scheduling.delay").description("The delay of scheduled tasks").publishPercentileHistogram().register(registry);
        }

        @Override
        public void incrementScheduledTasks() {
            this.scheduledTasksCounter.increment();
        }

        @Override
        public void decrementScheduledTasks() {
            this.scheduledTasksCounter.decrement();
        }

        @Override
        public void observeScheduledTaskExecution(long delay) {
            this.scheduledTaskDelay.record(delay, TimeUnit.MILLISECONDS);
        }
    }
}

