/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.metrics;

import io.camunda.zeebe.stream.impl.metrics.StreamMetricsDoc;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;

public final class ReplayMetrics {
    private final AtomicLong lastSourcePosition = new AtomicLong();
    private final Clock clock;
    private final Counter replayEventsCount;
    private final Timer replayDurationTimer;

    public ReplayMetrics(MeterRegistry registry) {
        this.clock = registry.config().clock();
        this.replayEventsCount = this.registerReplayEventsCount(registry);
        this.replayDurationTimer = this.registerReplayDuration(registry);
        this.registerLastSourcePosition(registry);
    }

    private Timer registerReplayDuration(MeterRegistry registry) {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.REPLAY_DURATION;
        return Timer.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).serviceLevelObjectives(meterDoc.getTimerSLOs()).register(registry);
    }

    private Counter registerReplayEventsCount(MeterRegistry registry) {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.REPLAY_EVENTS_COUNT;
        return Counter.builder((String)meterDoc.getName()).description(meterDoc.getDescription()).register(registry);
    }

    private void registerLastSourcePosition(MeterRegistry registry) {
        StreamMetricsDoc meterDoc = StreamMetricsDoc.LAST_SOURCE_POSITION;
        Gauge.builder((String)meterDoc.getName(), (Object)this.lastSourcePosition, AtomicLong::longValue).description(meterDoc.getDescription()).register(registry);
    }

    public void event() {
        this.replayEventsCount.increment();
    }

    public CloseableSilently startReplayDurationTimer() {
        return MicrometerUtil.timer((Timer)this.replayDurationTimer, (Timer.Sample)Timer.start((Clock)this.clock));
    }

    public void setLastSourcePosition(long position) {
        this.lastSourcePosition.set(position);
    }
}

