/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;
import org.agrona.sbe.MessageEncoderFlyweight;

public abstract class SbeBufferWriterReader<E extends MessageEncoderFlyweight, D extends MessageDecoderFlyweight>
implements BufferWriter,
BufferReader {
    protected final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    protected final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();

    protected abstract E getBodyEncoder();

    protected abstract D getBodyDecoder();

    public void reset() {
    }

    public void wrap(DirectBuffer buffer) {
        this.wrap(buffer, 0, buffer.capacity());
    }

    public int getLength() {
        return this.headerDecoder.encodedLength() + this.getBodyEncoder().sbeBlockLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.getBodyEncoder().sbeBlockLength()).templateId(this.getBodyEncoder().sbeTemplateId()).schemaId(this.getBodyEncoder().sbeSchemaId()).version(this.getBodyEncoder().sbeSchemaVersion());
        this.getBodyEncoder().wrap(buffer, offset + this.headerEncoder.encodedLength());
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        this.headerDecoder.wrap(buffer, offset);
        this.getBodyDecoder().wrap(buffer, offset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
    }

    public boolean tryWrap(DirectBuffer buffer) {
        return this.tryWrap(buffer, 0, buffer.capacity());
    }

    public boolean tryWrap(DirectBuffer buffer, int offset, int length) {
        this.headerDecoder.wrap(buffer, offset);
        if (this.headerDecoder.schemaId() == this.getBodyDecoder().sbeSchemaId() && this.headerDecoder.templateId() == this.getBodyDecoder().sbeTemplateId()) {
            this.wrap(buffer, offset, length);
            return true;
        }
        return false;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getLength());
        UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
        this.write((MutableDirectBuffer)buffer, 0);
        return byteBuffer;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.write((MutableDirectBuffer)buffer, 0);
        return bytes;
    }
}

