/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.db;

import io.camunda.zeebe.db.DbValue;
import java.util.Arrays;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

final class Bytes
implements Comparable<Bytes> {
    private final byte[] byteArray;

    private Bytes(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public int hashCode() {
        return Arrays.hashCode(this.byteArray);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bytes bytes = (Bytes)o;
        return Arrays.equals(this.byteArray, bytes.byteArray);
    }

    @Override
    public int compareTo(Bytes other) {
        return Arrays.compareUnsigned(this.byteArray, other.byteArray);
    }

    byte[] toBytes() {
        return this.byteArray;
    }

    static Bytes fromByteArray(byte[] array, int length) {
        return new Bytes(Arrays.copyOfRange(array, 0, length));
    }

    static Bytes fromByteArray(byte[] array) {
        return new Bytes(Arrays.copyOf(array, array.length));
    }

    static Bytes fromExpandableArrayBuffer(ExpandableArrayBuffer buffer) {
        return Bytes.fromByteArray(buffer.byteArray());
    }

    static Bytes fromDbValue(DbValue value) {
        ExpandableArrayBuffer valueBuffer = new ExpandableArrayBuffer(0);
        value.write((MutableDirectBuffer)valueBuffer, 0);
        return Bytes.fromExpandableArrayBuffer(valueBuffer);
    }

    public static Bytes empty() {
        return new Bytes(new byte[0]);
    }
}

