/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyListener;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import io.camunda.zeebe.gateway.impl.broker.PublishMessageDispatchStrategy;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

final class PublishMessageDispatchStrategyTest {
    PublishMessageDispatchStrategyTest() {
    }

    @Test
    void shouldDispatchViaTopology() {
        String correlationKey = "correlationKey";
        PublishMessageDispatchStrategy dispatchStrategy = new PublishMessageDispatchStrategy("correlationKey");
        int partitionCount = 3;
        TestTopologyManager topologyManager = new TestTopologyManager(new TestBrokerClusterState(3), ClusterConfiguration.uninitialized());
        Assertions.assertEquals((int)SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)"correlationKey"), (int)3), (int)dispatchStrategy.determinePartition((BrokerTopologyManager)topologyManager));
    }

    @Test
    void shouldDispatchViaRoutingState() {
        String correlationKey = "correlationKey";
        PublishMessageDispatchStrategy dispatchStrategy = new PublishMessageDispatchStrategy("correlationKey");
        int partitionCount = 3;
        int messagePartitionCount = 2;
        RoutingState routingState = new RoutingState(1L, Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), (RoutingState.MessageCorrelation)new RoutingState.MessageCorrelation.HashMod(2));
        ClusterConfiguration clusterConfiguration = new ClusterConfiguration(1L, Map.of(), Optional.empty(), Optional.empty(), Optional.of(routingState));
        TestTopologyManager topologyManager = new TestTopologyManager(new TestBrokerClusterState(3), clusterConfiguration);
        Assertions.assertEquals((int)SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)"correlationKey"), (int)2), (int)dispatchStrategy.determinePartition((BrokerTopologyManager)topologyManager));
    }

    private record TestTopologyManager(BrokerClusterState topology, ClusterConfiguration clusterConfiguration) implements BrokerTopologyManager
    {
        public BrokerClusterState getTopology() {
            return this.topology;
        }

        public ClusterConfiguration getClusterConfiguration() {
            return this.clusterConfiguration;
        }

        public void addTopologyListener(BrokerTopologyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeTopologyListener(BrokerTopologyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
            throw new UnsupportedOperationException();
        }
    }

    private record TestBrokerClusterState(int partitionCount) implements BrokerClusterState
    {
        public boolean isInitialized() {
            return true;
        }

        public int getClusterSize() {
            throw new UnsupportedOperationException();
        }

        public int getPartitionsCount() {
            return this.partitionCount;
        }

        public int getReplicationFactor() {
            throw new UnsupportedOperationException();
        }

        public int getLeaderForPartition(int partition) {
            throw new UnsupportedOperationException();
        }

        public Set<Integer> getFollowersForPartition(int partition) {
            throw new UnsupportedOperationException();
        }

        public Set<Integer> getInactiveNodesForPartition(int partition) {
            throw new UnsupportedOperationException();
        }

        public int getRandomBroker() {
            throw new UnsupportedOperationException();
        }

        public List<Integer> getPartitions() {
            throw new UnsupportedOperationException();
        }

        public List<Integer> getBrokers() {
            throw new UnsupportedOperationException();
        }

        public String getBrokerAddress(int brokerId) {
            throw new UnsupportedOperationException();
        }

        public int getPartition(int index) {
            throw new UnsupportedOperationException();
        }

        public String getBrokerVersion(int brokerId) {
            throw new UnsupportedOperationException();
        }

        public PartitionHealthStatus getPartitionHealth(int brokerId, int partition) {
            throw new UnsupportedOperationException();
        }
    }
}

