/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.UserRequest;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.validator.routines.EmailValidator;
import org.springframework.http.ProblemDetail;

public final class UserValidator {
    public static Optional<ProblemDetail> validateUserCreateRequest(UserRequest request) {
        ArrayList<String> violations = new ArrayList<String>();
        if (request.getUsername() == null || request.getUsername().isBlank()) {
            violations.add("No %s provided".formatted("username"));
        }
        if (request.getName() == null || request.getName().isBlank()) {
            violations.add("No %s provided".formatted("name"));
        }
        if (request.getPassword() == null || request.getPassword().isBlank()) {
            violations.add("No %s provided".formatted("password"));
        }
        if (request.getEmail() == null || request.getEmail().isBlank()) {
            violations.add("No %s provided".formatted("email"));
        } else if (!EmailValidator.getInstance().isValid(request.getEmail())) {
            violations.add("The provided email '%s' is not valid".formatted(request.getEmail()));
        }
        return RequestValidator.createProblemDetail(violations);
    }
}

