/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.Changeset;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskAssignmentRequest;
import io.camunda.zeebe.gateway.protocol.rest.UserTaskUpdateRequest;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;

public final class UserTaskRequestValidator {
    public static Optional<ProblemDetail> validateAssignmentRequest(UserTaskAssignmentRequest assignmentRequest) {
        if (assignmentRequest.getAssignee() == null || assignmentRequest.getAssignee().isBlank()) {
            ProblemDetail problemDetail = RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, "No %s provided".formatted("assignee"), RejectionType.INVALID_ARGUMENT.name());
            return Optional.of(problemDetail);
        }
        return Optional.empty();
    }

    public static Optional<ProblemDetail> validateUpdateRequest(UserTaskUpdateRequest updateRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        if (updateRequest == null || updateRequest.getAction() == null && RequestValidator.isEmpty(updateRequest.getChangeset())) {
            violations.add("No update data provided. Provide at least an \"action\" or a non-null value for a supported attribute in the \"changeset\"");
        }
        if (updateRequest != null && !RequestValidator.isEmpty(updateRequest.getChangeset())) {
            Changeset changeset = updateRequest.getChangeset();
            RequestValidator.validateDate(changeset.getDueDate(), "due date", violations);
            RequestValidator.validateDate(changeset.getFollowUpDate(), "follow-up date", violations);
            UserTaskRequestValidator.validatePriority(changeset.getPriority(), violations);
        }
        if (violations.isEmpty()) {
            return Optional.empty();
        }
        return RequestValidator.createProblemDetail(violations);
    }

    private static void validatePriority(Integer priority, List<String> violations) {
        if (priority != null && (priority < 0 || priority > 100)) {
            violations.add("The value for %s is '%s' but must be %s".formatted("priority", priority, "within the [0,100] range"));
        }
    }
}

