/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.Changeset;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.protocol.record.RejectionType;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;

public final class RequestValidator {
    public static Optional<ProblemDetail> createProblemDetail(List<String> violations) {
        String problems = String.join((CharSequence)". ", violations) + ".";
        return violations.isEmpty() ? Optional.empty() : Optional.of(RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, problems, RejectionType.INVALID_ARGUMENT.name()));
    }

    public static void validateDate(String dateString, String attributeName, List<String> violations) {
        if (dateString != null && !dateString.isEmpty()) {
            try {
                ZonedDateTime.parse(dateString);
            }
            catch (DateTimeParseException ex) {
                violations.add("The provided %s '%s' cannot be parsed as a date according to RFC 3339, section 5.6".formatted(attributeName, dateString));
            }
        }
    }

    public static boolean isEmpty(Changeset changeset) {
        return changeset == null || changeset.getFollowUpDate() == null && changeset.getDueDate() == null && changeset.getCandidateGroups() == null && changeset.getCandidateUsers() == null && changeset.getPriority() == null;
    }

    public static Optional<ProblemDetail> validate(Consumer<List<String>> customValidation) {
        ArrayList<String> violations = new ArrayList<String>();
        customValidation.accept(violations);
        return RequestValidator.createProblemDetail(violations);
    }
}

