/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.CancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.CreateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceMappingInstruction;
import io.camunda.zeebe.gateway.protocol.rest.MigrateProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceActivateInstruction;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceRequest;
import io.camunda.zeebe.gateway.protocol.rest.ModifyProcessInstanceTerminateInstruction;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.http.ProblemDetail;

public class ProcessInstanceRequestValidator {
    public static Optional<ProblemDetail> validateCreateProcessInstanceRequest(CreateProcessInstanceRequest request) {
        return RequestValidator.validate(violations -> {
            if (request.getProcessDefinitionId() == null && request.getProcessDefinitionKey() == null) {
                violations.add("At least one of %s is required".formatted(List.of("processDefinitionId", "processDefinitionKey")));
            }
            if (request.getProcessDefinitionId() != null && request.getProcessDefinitionKey() != null) {
                violations.add("Only one of %s is allowed".formatted(List.of("processDefinitionId", "processDefinitionKey")));
            }
            ProcessInstanceRequestValidator.validateOperationReference(request.getOperationReference(), violations);
        });
    }

    public static Optional<ProblemDetail> validateCancelProcessInstanceRequest(CancelProcessInstanceRequest request) {
        return RequestValidator.validate(violations -> {
            if (request != null) {
                ProcessInstanceRequestValidator.validateOperationReference(request.getOperationReference(), violations);
            }
        });
    }

    public static Optional<ProblemDetail> validateMigrateProcessInstanceRequest(MigrateProcessInstanceRequest request) {
        return RequestValidator.validate(violations -> {
            if (request.getTargetProcessDefinitionKey() == null) {
                violations.add("No %s provided".formatted("targetProcessDefinitionKey"));
            }
            if (request.getMappingInstructions() == null || request.getMappingInstructions().isEmpty()) {
                violations.add("No %s provided".formatted("mappingInstructions"));
            } else {
                ProcessInstanceRequestValidator.validateMappingInstructions(request.getMappingInstructions(), violations);
            }
            ProcessInstanceRequestValidator.validateOperationReference(request.getOperationReference(), violations);
        });
    }

    public static Optional<ProblemDetail> validateModifyProcessInstanceRequest(ModifyProcessInstanceRequest request) {
        return RequestValidator.validate(violations -> {
            ProcessInstanceRequestValidator.validateActivateInstructions(request.getActivateInstructions(), violations);
            ProcessInstanceRequestValidator.validateTerminateInstructions(request.getTerminateInstructions(), violations);
            ProcessInstanceRequestValidator.validateOperationReference(request.getOperationReference(), violations);
        });
    }

    private static void validateMappingInstructions(List<MigrateProcessInstanceMappingInstruction> mappingInstructions, List<String> violations) {
        ProcessInstanceRequestValidator.validateInstructions(mappingInstructions, instruction -> instruction.getSourceElementId() != null && !instruction.getSourceElementId().isEmpty() && instruction.getTargetElementId() != null && !instruction.getTargetElementId().isEmpty(), violations, "All %s are required".formatted(List.of("sourceElementId", "targetElementId")));
    }

    private static void validateActivateInstructions(List<ModifyProcessInstanceActivateInstruction> instructions, List<String> violations) {
        ProcessInstanceRequestValidator.validateInstructions(instructions, instruction -> instruction.getElementId() != null, violations, "No %s provided".formatted("elementId"));
        List variableInstructions = instructions.stream().flatMap(instruction -> instruction.getVariableInstructions().stream()).toList();
        ProcessInstanceRequestValidator.validateInstructions(variableInstructions, variableInstruction -> !variableInstruction.getVariables().isEmpty(), violations, "No %s provided".formatted("variables"));
    }

    private static void validateTerminateInstructions(List<ModifyProcessInstanceTerminateInstruction> instructions, List<String> violations) {
        ProcessInstanceRequestValidator.validateInstructions(instructions, instruction -> instruction.getElementInstanceKey() != null, violations, "No %s provided".formatted("elementInstanceKey"));
    }

    private static <T> void validateInstructions(List<T> instructions, Predicate<T> match, List<String> violations, String message) {
        boolean areInstructionsValid = instructions.stream().allMatch(match);
        if (!areInstructionsValid) {
            violations.add(message);
        }
    }

    private static void validateOperationReference(Long operationReference, List<String> violations) {
        if (operationReference != null && operationReference < 1L) {
            violations.add("The value for %s is '%s' but must be %s".formatted("operationReference", operationReference, "> 0"));
        }
    }
}

