/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.rest.RequestMapper;
import io.camunda.zeebe.gateway.rest.RestErrorMapper;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;

public final class MultiTenancyValidator {
    private static final Pattern TENANT_ID_MASK = Pattern.compile("^[\\w\\.-]{1,31}$");

    public static Optional<ProblemDetail> validateAuthorization(String tenantId, boolean multiTenancyEnabled, String commandName) {
        if (!multiTenancyEnabled) {
            return Optional.empty();
        }
        List authorizedTenants = RequestMapper.getAuthentication().authenticatedTenantIds();
        if (authorizedTenants == null || !authorizedTenants.contains(tenantId)) {
            return Optional.of(RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Expected to handle request %s with tenant identifier '%s', but %s".formatted(commandName, tenantId, "tenant is not authorized to perform this request"), HttpStatus.UNAUTHORIZED.name()));
        }
        return Optional.empty();
    }

    public static Either<ProblemDetail, String> validateTenantId(String tenantId, boolean multiTenancyEnabled, String commandName) {
        boolean hasTenantId;
        boolean bl = hasTenantId = tenantId != null && !tenantId.isBlank();
        if (!multiTenancyEnabled) {
            if (hasTenantId && !"<default>".equals(tenantId)) {
                return Either.left((Object)RestErrorMapper.createProblemDetail((HttpStatusCode)HttpStatus.BAD_REQUEST, "Expected to handle request %s with tenant identifier '%s', but %s".formatted(commandName, tenantId, "multi-tenancy is disabled"), RejectionType.INVALID_ARGUMENT.name()));
            }
            return Either.right((Object)"<default>");
        }
        ArrayList<String> violations = new ArrayList<String>();
        if (!hasTenantId) {
            violations.add("Expected to handle request %s with tenant identifier '%s', but %s".formatted(commandName, tenantId, "no tenant identifier was provided"));
        } else if (tenantId.length() > 31) {
            violations.add("Expected to handle request %s with tenant identifier '%s', but %s".formatted(commandName, tenantId, "tenant identifier is longer than 31 characters"));
        } else if (!"<default>".equals(tenantId) && !TENANT_ID_MASK.matcher(tenantId).matches()) {
            violations.add("Expected to handle request %s with tenant identifier '%s', but %s".formatted(commandName, tenantId, "tenant identifier contains illegal characters"));
        }
        Optional<ProblemDetail> problemDetail = RequestValidator.createProblemDetail(violations);
        return problemDetail.map(Either::left).orElseGet(() -> Either.right((Object)tenantId));
    }
}

