/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.MessageCorrelationRequest;
import io.camunda.zeebe.gateway.protocol.rest.MessagePublicationRequest;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.Optional;
import org.springframework.http.ProblemDetail;

public final class MessageRequestValidator {
    public static Optional<ProblemDetail> validateMessageCorrelationRequest(MessageCorrelationRequest correlationRequest) {
        return RequestValidator.validate(violations -> {
            if (correlationRequest.getName() == null || correlationRequest.getName().isBlank()) {
                violations.add("No %s provided".formatted("messageName"));
            }
        });
    }

    public static Optional<ProblemDetail> validateMessagePublicationRequest(MessagePublicationRequest publicationRequest) {
        return RequestValidator.validate(violations -> {
            if (publicationRequest.getName() == null || publicationRequest.getName().isBlank()) {
                violations.add("No %s provided".formatted("name"));
            }
        });
    }
}

