/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.JobActivationRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobChangeset;
import io.camunda.zeebe.gateway.protocol.rest.JobErrorRequest;
import io.camunda.zeebe.gateway.protocol.rest.JobUpdateRequest;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ProblemDetail;

public final class JobRequestValidator {
    public static Optional<ProblemDetail> validateJobActivationRequest(JobActivationRequest activationRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        if (activationRequest.getType() == null || activationRequest.getType().isBlank()) {
            violations.add("No %s provided".formatted("type"));
        }
        if (activationRequest.getTimeout() == null) {
            violations.add("No %s provided".formatted("timeout"));
        } else if (activationRequest.getTimeout() < 1L) {
            violations.add("The value for %s is '%s' but must be %s".formatted("timeout", activationRequest.getTimeout(), "greater than 0"));
        }
        if (activationRequest.getMaxJobsToActivate() == null) {
            violations.add("No %s provided".formatted("maxJobsToActivate"));
        } else if (activationRequest.getMaxJobsToActivate() < 1) {
            violations.add("The value for %s is '%s' but must be %s".formatted("maxJobsToActivate", activationRequest.getTimeout(), "greater than 0"));
        }
        return RequestValidator.createProblemDetail(violations);
    }

    public static Optional<ProblemDetail> validateJobErrorRequest(JobErrorRequest errorRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        if (errorRequest.getErrorCode() == null || errorRequest.getErrorCode().isBlank()) {
            violations.add("No %s provided".formatted("errorCode"));
        }
        return RequestValidator.createProblemDetail(violations);
    }

    public static Optional<ProblemDetail> validateJobUpdateRequest(JobUpdateRequest updateRequest) {
        ArrayList<String> violations = new ArrayList<String>();
        JobChangeset changeset = updateRequest.getChangeset();
        if (changeset == null || changeset.getRetries() == null && changeset.getTimeout() == null) {
            violations.add("At least one of %s is required".formatted(List.of("retries", "timeout")));
        }
        return RequestValidator.createProblemDetail(violations);
    }
}

