/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.DocumentLinkRequest;
import io.camunda.zeebe.gateway.protocol.rest.DocumentMetadata;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.http.ProblemDetail;

public class DocumentValidator {
    public static Optional<ProblemDetail> validateDocumentMetadata(DocumentMetadata metadata) {
        ArrayList<String> violations = new ArrayList<String>();
        if (metadata == null) {
            return Optional.empty();
        }
        if (metadata.getFileName() != null && metadata.getFileName().isBlank()) {
            violations.add("The file name must not be empty, if present");
        }
        if (metadata.getContentType() != null && metadata.getContentType().isBlank()) {
            violations.add("The content type must not be empty, if present");
        }
        if (metadata.getExpiresAt() != null) {
            RequestValidator.validateDate(metadata.getExpiresAt(), "expiresAt", violations);
        }
        return RequestValidator.createProblemDetail(violations);
    }

    public static Optional<ProblemDetail> validateDocumentLinkParams(DocumentLinkRequest request) {
        ArrayList<String> violations = new ArrayList<String>();
        if (request == null) {
            return Optional.empty();
        }
        if (request.getExpiresAt() != null) {
            RequestValidator.validateDate(request.getExpiresAt(), "expiresAt", violations);
            long now = System.currentTimeMillis();
            long expiresAtDate = ZonedDateTime.parse(request.getExpiresAt()).toInstant().toEpochMilli();
            if (expiresAtDate < now) {
                violations.add("The expiration date must be in the future");
            }
        }
        return RequestValidator.createProblemDetail(violations);
    }
}

