/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.rest.validator;

import io.camunda.zeebe.gateway.protocol.rest.ClockPinRequest;
import io.camunda.zeebe.gateway.rest.validator.RequestValidator;
import java.util.Optional;
import org.springframework.http.ProblemDetail;

public class ClockValidator {
    public static Optional<ProblemDetail> validateClockPinRequest(ClockPinRequest pinRequest) {
        return RequestValidator.validate(violations -> Optional.ofNullable(pinRequest.getTimestamp()).ifPresentOrElse(timestamp -> {
            if (timestamp < 0L) {
                violations.add("The value for %s is '%s' but must be %s".formatted("timestamp", timestamp, "not negative"));
            }
        }, () -> violations.add("No %s provided".formatted("timestamp"))));
    }
}

